/*
 * Decompiled with CFR 0.152.
 */
package com.openfaas.model;

import com.openfaas.model.IRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class Request
implements IRequest {
    private Map<String, String> headers;
    private String body;
    private Map<String, String> queryParameters;
    private String queryRaw;
    private String pathRaw;
    private Map<String, String> path;

    public Request(String body, Map<String, String> headers) {
        this.body = body;
        this.headers = headers;
    }

    public Request(String body, Map<String, String> headers, String queryRaw, String path) {
        this.body = body;
        this.headers = headers;
        this.queryRaw = queryRaw;
        this.queryParameters = this.parseQueryParameters();
        this.pathRaw = path;
        this.path = this.parsePathParameters();
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String key) {
        if (!this.headers.containsKey(key)) {
            return null;
        }
        return this.headers.get(key);
    }

    @Override
    public String getQueryRaw() {
        return this.queryRaw;
    }

    @Override
    public Map<String, String> getQuery() {
        return this.queryParameters;
    }

    @Override
    public String getPathRaw() {
        return this.pathRaw;
    }

    @Override
    public Map<String, String> getPath() {
        return this.path;
    }

    private Map<String, String> parsePathParameters() {
        HashMap<String, String> res = new HashMap<String, String>();
        if (this.pathRaw != null && this.pathRaw.length() > 0) {
            String firstLetter = this.pathRaw.substring(0, 1);
            String[] params = this.pathRaw.substring(1).split("/");
            String key = "";
            for (String param : params) {
                if (key.length() > 0) {
                    res.put(key, param);
                    key = "";
                    continue;
                }
                key = param;
            }
            if (key.length() > 0) {
                res.put(key, "");
            }
        }
        return res;
    }

    private Map<String, String> parseQueryParameters() {
        HashMap<String, String> reqParametersMap = new HashMap<String, String>();
        if (this.queryRaw != null) {
            String[] pairs;
            for (String pair : pairs = this.queryRaw.split("[&]")) {
                String[] param = pair.split("[=]");
                String key = null;
                String value = null;
                try {
                    if (param.length > 0) {
                        key = URLDecoder.decode(param[0], System.getProperty("file.encoding"));
                    }
                    if (param.length > 1) {
                        value = URLDecoder.decode(param[1], System.getProperty("file.encoding"));
                    }
                    reqParametersMap.put(key, value);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return reqParametersMap;
    }
}

