/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.elsql;

public class ElSqlConfig {
    public static final ElSqlConfig DEFAULT = new ElSqlConfig("Default");
    public static final ElSqlConfig POSTGRES = new PostgresElSqlConfig();
    public static final ElSqlConfig HSQL = new HsqlElSqlConfig();
    public static final ElSqlConfig MYSQL = new MySqlElSqlConfig();
    public static final ElSqlConfig ORACLE = new OracleElSqlConfig();
    public static final ElSqlConfig SQL_SERVER_2008 = new SqlServer2008ElSqlConfig();
    public static final ElSqlConfig VERTICA = new VerticaElSqlConfig();
    private final String _name;

    public ElSqlConfig(String name) {
        this._name = name;
    }

    public final String getName() {
        return this._name;
    }

    public boolean isLikeWildcard(String value) {
        boolean escape = false;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (escape) {
                escape = false;
                continue;
            }
            if (ch == '\\') {
                escape = true;
                continue;
            }
            if (ch != '%' && ch != '_') continue;
            return true;
        }
        return false;
    }

    public String getLikeSuffix() {
        return "";
    }

    public String addPaging(String selectToPage, int offset, int fetchLimit) {
        return selectToPage + (selectToPage.endsWith(" ") ? "" : " ") + this.getPaging(offset, fetchLimit);
    }

    public String getPaging(int offset, int fetchLimit) {
        if (fetchLimit == 0 && offset == 0) {
            return "";
        }
        if (fetchLimit == 0) {
            return "OFFSET " + offset + " ROWS ";
        }
        if (offset == 0) {
            return "FETCH FIRST " + fetchLimit + " ROWS ONLY ";
        }
        return "OFFSET " + offset + " ROWS FETCH NEXT " + fetchLimit + " ROWS ONLY ";
    }

    public String toString() {
        return "ElSqlConfig[" + this._name + "]";
    }

    private static class VerticaElSqlConfig
    extends ElSqlConfig {
        public VerticaElSqlConfig() {
            super("Vertica");
        }
    }

    private static class SqlServer2008ElSqlConfig
    extends ElSqlConfig {
        public SqlServer2008ElSqlConfig() {
            super("SqlServer2008");
        }

        @Override
        public String addPaging(String selectToPage, int offset, int fetchLimit) {
            if (fetchLimit == 0 && offset == 0) {
                return selectToPage.replaceFirst("SELECT ", "SELECT TOP 2147483647 ");
            }
            int start = offset + 1;
            int end = offset + fetchLimit;
            String columns = selectToPage.substring(selectToPage.indexOf("SELECT ") + 7, selectToPage.indexOf(" FROM "));
            String from = selectToPage.substring(selectToPage.indexOf(" FROM ") + 6, selectToPage.indexOf(" ORDER BY "));
            String order = selectToPage.substring(selectToPage.indexOf(" ORDER BY ") + 10);
            String inner = "SELECT " + columns + ", ROW_NUMBER() OVER (ORDER BY " + order.trim() + ") AS ROW_NUM FROM " + from;
            return "SELECT * FROM (" + inner + ") AS ROW_TABLE WHERE ROW_NUM >= " + start + " AND ROW_NUM <= " + end;
        }

        @Override
        public String getPaging(int offset, int fetchLimit) {
            throw new UnsupportedOperationException();
        }
    }

    private static class OracleElSqlConfig
    extends ElSqlConfig {
        public OracleElSqlConfig() {
            super("Oracle");
        }

        @Override
        public String addPaging(String selectToPage, int offset, int fetchLimit) {
            if (fetchLimit == 0 && offset == 0) {
                return selectToPage;
            }
            if (offset == 0 && fetchLimit > 0) {
                return "SELECT * FROM ( " + selectToPage + " ) where rownum <= " + fetchLimit;
            }
            int start = offset;
            int end = offset + fetchLimit;
            return "SELECT * FROM (SELECT  row_.*,rownum rownum_ FROM ( " + selectToPage + " ) row_ where rownum <= " + end + ")  WHERE rownum_  > " + start;
        }

        @Override
        public String getPaging(int offset, int fetchLimit) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MySqlElSqlConfig
    extends ElSqlConfig {
        public MySqlElSqlConfig() {
            super("MySql");
        }

        @Override
        public String getPaging(int offset, int fetchLimit) {
            if (fetchLimit == 0 && offset == 0) {
                return "";
            }
            if (fetchLimit == 0) {
                return "OFFSET " + offset + " ";
            }
            if (offset == 0) {
                return "LIMIT " + fetchLimit + " ";
            }
            return "LIMIT " + fetchLimit + " OFFSET " + offset + " ";
        }
    }

    private static class HsqlElSqlConfig
    extends ElSqlConfig {
        public HsqlElSqlConfig() {
            super("HSQL");
        }

        @Override
        public String getLikeSuffix() {
            return "ESCAPE '\\' ";
        }
    }

    private static class PostgresElSqlConfig
    extends ElSqlConfig {
        public PostgresElSqlConfig() {
            super("Postgres");
        }
    }
}

