/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.elsql;

import com.opengamma.elsql.ContainerSqlFragment;
import com.opengamma.elsql.SqlFragments;
import com.opengamma.elsql.SqlParams;
import java.util.Arrays;

final class LoopSqlFragment
extends ContainerSqlFragment {
    private final String _sizeVariable;

    LoopSqlFragment(String variable) {
        this._sizeVariable = variable;
    }

    @Override
    void toSQL(StringBuilder buf, SqlFragments fragments, SqlParams params, int[] loopIndex) {
        int size = this.extractSize(params);
        int[] childLoopIndex = Arrays.copyOf(loopIndex, loopIndex.length + 1);
        for (int i = 0; i < size; ++i) {
            StringBuilder part = new StringBuilder();
            childLoopIndex[childLoopIndex.length - 1] = i;
            super.toSQL(part, fragments, params, childLoopIndex);
            int joinIndex = part.indexOf("@LOOPJOIN ");
            if (joinIndex >= 0) {
                if (i >= size - 1) {
                    part.setLength(joinIndex);
                } else {
                    part.delete(joinIndex, joinIndex + 10);
                }
            }
            buf.append((CharSequence)part);
        }
    }

    private int extractSize(SqlParams params) {
        if (this._sizeVariable.startsWith(":")) {
            String var = LoopSqlFragment.extractVariableName(this._sizeVariable);
            Object sizeObj = params.get(var);
            if (sizeObj instanceof Number) {
                return ((Number)sizeObj).intValue();
            }
            if (sizeObj instanceof String) {
                return Integer.parseInt((String)sizeObj);
            }
            if (sizeObj == null) {
                throw new IllegalArgumentException("Loop size variable not found: " + var);
            }
            throw new IllegalArgumentException("Loop size variable must be Number or String: " + var);
        }
        return Integer.parseInt(this._sizeVariable);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getFragments();
    }
}

