/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.DateAdjuster;
import java.time.LocalDate;
import java.time.Year;

public final class DateAdjusters {
    private DateAdjusters() {
    }

    public static DateAdjuster nextLeapDay() {
        return DateAdjusters::nextLeapDay;
    }

    static LocalDate nextLeapDay(LocalDate input) {
        if (input.getMonthValue() == 2 && input.getDayOfMonth() == 29) {
            return DateAdjusters.ensureLeapDay(input.getYear() + 4);
        }
        if (input.isLeapYear() && input.getMonthValue() <= 2) {
            return LocalDate.of(input.getYear(), 2, 29);
        }
        return DateAdjusters.ensureLeapDay(input.getYear() / 4 * 4 + 4);
    }

    public static DateAdjuster nextOrSameLeapDay() {
        return DateAdjusters::nextOrSameLeapDay;
    }

    static LocalDate nextOrSameLeapDay(LocalDate input) {
        if (input.getMonthValue() == 2 && input.getDayOfMonth() == 29) {
            return input;
        }
        if (input.isLeapYear() && input.getMonthValue() <= 2) {
            return LocalDate.of(input.getYear(), 2, 29);
        }
        return DateAdjusters.ensureLeapDay(input.getYear() / 4 * 4 + 4);
    }

    private static LocalDate ensureLeapDay(int possibleLeapYear) {
        if (Year.isLeap(possibleLeapYear)) {
            return LocalDate.of(possibleLeapYear, 2, 29);
        }
        return LocalDate.of(possibleLeapYear + 4, 2, 29);
    }
}

