/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.FxIndexObservation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableFxIndex
implements FxIndex,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurrencyPair currencyPair;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final HolidayCalendarId fixingCalendar;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment fixingDateOffset;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment maturityDateOffset;
    private static final long serialVersionUID = 1L;

    private static void preBuild(Builder builder) {
        if (builder.fixingDateOffset == null && builder.fixingCalendar != null && builder.maturityDateOffset != null) {
            int days = builder.maturityDateOffset.getDays();
            HolidayCalendarId maturityCal = builder.maturityDateOffset.getCalendar();
            if (maturityCal.combinedWith(builder.fixingCalendar).equals(maturityCal)) {
                builder.fixingDateOffset = DaysAdjustment.ofBusinessDays(-days, maturityCal);
            } else {
                builder.fixingDateOffset = DaysAdjustment.ofBusinessDays(-days, maturityCal, BusinessDayAdjustment.of(BusinessDayConventions.PRECEDING, builder.fixingCalendar));
            }
        }
    }

    @Override
    public LocalDate calculateMaturityFromFixing(LocalDate fixingDate, ReferenceData refData) {
        HolidayCalendar fixingCal = this.fixingCalendar.resolve(refData);
        LocalDate fixingBusinessDay = fixingCal.nextOrSame(fixingDate);
        return this.maturityDateOffset.adjust(fixingBusinessDay, refData);
    }

    @Override
    public LocalDate calculateFixingFromMaturity(LocalDate maturityDate, ReferenceData refData) {
        LocalDate maturityBusinessDay = this.maturityDateCalendar().resolve(refData).nextOrSame(maturityDate);
        HolidayCalendar fixingCal = this.fixingCalendar.resolve(refData);
        DateAdjuster maturityFromFixing = this.maturityDateOffset.resolve(refData);
        LocalDate fixingDate = maturityBusinessDay;
        while (fixingCal.isHoliday(fixingDate) || maturityFromFixing.adjust(fixingDate).isAfter(maturityBusinessDay)) {
            fixingDate = fixingDate.minusDays(1L);
        }
        return fixingDate;
    }

    private HolidayCalendarId maturityDateCalendar() {
        HolidayCalendarId cal = this.maturityDateOffset.getResultCalendar();
        return cal == HolidayCalendarIds.NO_HOLIDAYS ? this.fixingCalendar : cal;
    }

    @Override
    public Function<LocalDate, FxIndexObservation> resolve(ReferenceData refData) {
        HolidayCalendar fixingCal = this.fixingCalendar.resolve(refData);
        DateAdjuster maturityAdj = this.maturityDateOffset.resolve(refData);
        return fixingDate -> this.create((LocalDate)fixingDate, fixingCal, maturityAdj);
    }

    private FxIndexObservation create(LocalDate fixingDate, HolidayCalendar fixingCal, DateAdjuster maturityAdjuster) {
        LocalDate fixingBusinessDay = fixingCal.nextOrSame(fixingDate);
        LocalDate maturityDate = maturityAdjuster.adjust(fixingBusinessDay);
        return new FxIndexObservation(this, fixingDate, maturityDate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImmutableFxIndex) {
            return this.name.equals(((ImmutableFxIndex)obj).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableFxIndex(String name, CurrencyPair currencyPair, HolidayCalendarId fixingCalendar, DaysAdjustment fixingDateOffset, DaysAdjustment maturityDateOffset) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
        JodaBeanUtils.notNull((Object)fixingCalendar, (String)"fixingCalendar");
        JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
        JodaBeanUtils.notNull((Object)maturityDateOffset, (String)"maturityDateOffset");
        this.name = name;
        this.currencyPair = currencyPair;
        this.fixingCalendar = fixingCalendar;
        this.fixingDateOffset = fixingDateOffset;
        this.maturityDateOffset = maturityDateOffset;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    @Override
    public HolidayCalendarId getFixingCalendar() {
        return this.fixingCalendar;
    }

    @Override
    public DaysAdjustment getFixingDateOffset() {
        return this.fixingDateOffset;
    }

    @Override
    public DaysAdjustment getMaturityDateOffset() {
        return this.maturityDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableFxIndex> {
        private String name;
        private CurrencyPair currencyPair;
        private HolidayCalendarId fixingCalendar;
        private DaysAdjustment fixingDateOffset;
        private DaysAdjustment maturityDateOffset;

        private Builder() {
        }

        private Builder(ImmutableFxIndex beanToCopy) {
            this.name = beanToCopy.getName();
            this.currencyPair = beanToCopy.getCurrencyPair();
            this.fixingCalendar = beanToCopy.getFixingCalendar();
            this.fixingDateOffset = beanToCopy.getFixingDateOffset();
            this.maturityDateOffset = beanToCopy.getMaturityDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case 394230283: {
                    return this.fixingCalendar;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1574797394: {
                    return this.maturityDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case 394230283: {
                    this.fixingCalendar = (HolidayCalendarId)newValue;
                    break;
                }
                case 873743726: {
                    this.fixingDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 1574797394: {
                    this.maturityDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableFxIndex build() {
            ImmutableFxIndex.preBuild(this);
            return new ImmutableFxIndex(this.name, this.currencyPair, this.fixingCalendar, this.fixingDateOffset, this.maturityDateOffset);
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder fixingCalendar(HolidayCalendarId fixingCalendar) {
            JodaBeanUtils.notNull((Object)fixingCalendar, (String)"fixingCalendar");
            this.fixingCalendar = fixingCalendar;
            return this;
        }

        public Builder fixingDateOffset(DaysAdjustment fixingDateOffset) {
            JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
            this.fixingDateOffset = fixingDateOffset;
            return this;
        }

        public Builder maturityDateOffset(DaysAdjustment maturityDateOffset) {
            JodaBeanUtils.notNull((Object)maturityDateOffset, (String)"maturityDateOffset");
            this.maturityDateOffset = maturityDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("ImmutableFxIndex.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("fixingCalendar").append('=').append(JodaBeanUtils.toString((Object)this.fixingCalendar)).append(',').append(' ');
            buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
            buf.append("maturityDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.maturityDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableFxIndex.class, String.class);
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", ImmutableFxIndex.class, CurrencyPair.class);
        private final MetaProperty<HolidayCalendarId> fixingCalendar = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingCalendar", ImmutableFxIndex.class, HolidayCalendarId.class);
        private final MetaProperty<DaysAdjustment> fixingDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDateOffset", ImmutableFxIndex.class, DaysAdjustment.class);
        private final MetaProperty<DaysAdjustment> maturityDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"maturityDateOffset", ImmutableFxIndex.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "currencyPair", "fixingCalendar", "fixingDateOffset", "maturityDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case 394230283: {
                    return this.fixingCalendar;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1574797394: {
                    return this.maturityDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableFxIndex> beanType() {
            return ImmutableFxIndex.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<HolidayCalendarId> fixingCalendar() {
            return this.fixingCalendar;
        }

        public MetaProperty<DaysAdjustment> fixingDateOffset() {
            return this.fixingDateOffset;
        }

        public MetaProperty<DaysAdjustment> maturityDateOffset() {
            return this.maturityDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutableFxIndex)bean).getName();
                }
                case 1005147787: {
                    return ((ImmutableFxIndex)bean).getCurrencyPair();
                }
                case 394230283: {
                    return ((ImmutableFxIndex)bean).getFixingCalendar();
                }
                case 873743726: {
                    return ((ImmutableFxIndex)bean).getFixingDateOffset();
                }
                case 1574797394: {
                    return ((ImmutableFxIndex)bean).getMaturityDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

