/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.location;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class Country
implements Comparable<Country>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ConcurrentMap<String, Country> CACHE = new ConcurrentHashMap<String, Country>();
    private static final CharMatcher CODE_MATCHER = CharMatcher.inRange((char)'A', (char)'Z');
    public static final Country EU = Country.of("EU");
    public static final Country BE = Country.of("BE");
    public static final Country CH = Country.of("CH");
    public static final Country CZ = Country.of("CZ");
    public static final Country DE = Country.of("DE");
    public static final Country DK = Country.of("DK");
    public static final Country ES = Country.of("ES");
    public static final Country FI = Country.of("FI");
    public static final Country FR = Country.of("FR");
    public static final Country GB = Country.of("GB");
    public static final Country GR = Country.of("GR");
    public static final Country HU = Country.of("HU");
    public static final Country IS = Country.of("IS");
    public static final Country IT = Country.of("IT");
    public static final Country LU = Country.of("LU");
    public static final Country NL = Country.of("NL");
    public static final Country NO = Country.of("NO");
    public static final Country PL = Country.of("PL");
    public static final Country PT = Country.of("PT");
    public static final Country SE = Country.of("SE");
    public static final Country SK = Country.of("SK");
    public static final Country TR = Country.of("TR");
    public static final Country AR = Country.of("AR");
    public static final Country BR = Country.of("BR");
    public static final Country CA = Country.of("CA");
    public static final Country CL = Country.of("CL");
    public static final Country MX = Country.of("MX");
    public static final Country US = Country.of("US");
    public static final Country AU = Country.of("AU");
    public static final Country CN = Country.of("CN");
    public static final Country EG = Country.of("EG");
    public static final Country HK = Country.of("HK");
    public static final Country ID = Country.of("ID");
    public static final Country IL = Country.of("IL");
    public static final Country IN = Country.of("IN");
    public static final Country JP = Country.of("JP");
    public static final Country KR = Country.of("KR");
    public static final Country MY = Country.of("MY");
    public static final Country NZ = Country.of("NZ");
    public static final Country RU = Country.of("RU");
    public static final Country SA = Country.of("SA");
    public static final Country SG = Country.of("SG");
    public static final Country TH = Country.of("TH");
    public static final Country ZA = Country.of("ZA");
    private final String code;

    public static Set<Country> getAvailableCountries() {
        return ImmutableSet.copyOf(CACHE.values());
    }

    @FromString
    public static Country of(String countryCode) {
        ArgChecker.notNull((Object)countryCode, (String)"countryCode");
        return CACHE.computeIfAbsent(countryCode, c -> Country.addCode(c));
    }

    private static Country addCode(String countryCode) {
        ArgChecker.matches((CharMatcher)CODE_MATCHER, (int)2, (int)2, (String)countryCode, (String)"countryCode", (String)"[A-Z][A-Z]");
        return new Country(countryCode);
    }

    public static Country parse(String countryCode) {
        ArgChecker.notNull((Object)countryCode, (String)"countryCode");
        return Country.of(countryCode.toUpperCase(Locale.ENGLISH));
    }

    private Country(String code) {
        this.code = code;
    }

    private Object readResolve() {
        return Country.of(this.code);
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public int compareTo(Country other) {
        return this.code.compareTo(other.code);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Country other = (Country)obj;
        return this.code.equals(other.code);
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    @ToString
    public String toString() {
        return this.code;
    }
}

