/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.collect.Messages;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ImmutableReferenceData
implements ReferenceData,
ImmutableBean,
Serializable {
    private static final ImmutableReferenceData EMPTY = new ImmutableReferenceData((Map<? extends ReferenceDataId<?>, ?>)ImmutableMap.of());
    @PropertyDefinition(validate="notNull", builderType="Map<? extends ReferenceDataId<?>, ?>")
    private final ImmutableMap<ReferenceDataId<?>, Object> values;
    private static final long serialVersionUID = 1L;

    public static ImmutableReferenceData of(Map<? extends ReferenceDataId<?>, ?> values) {
        values.forEach((id, value) -> ImmutableReferenceData.validateEntry(id, value));
        return new ImmutableReferenceData(values);
    }

    public static <T> ImmutableReferenceData of(ReferenceDataId<T> id, T value) {
        ImmutableReferenceData.validateEntry(id, value);
        return new ImmutableReferenceData((Map<? extends ReferenceDataId<?>, ?>)ImmutableMap.of(id, value));
    }

    private static void validateEntry(ReferenceDataId<?> id, Object value) {
        if (!id.getReferenceDataType().isInstance(value)) {
            if (value == null) {
                throw new IllegalArgumentException(Messages.format((String)"Value for identifier '{}' must not be null", id));
            }
            throw new ClassCastException(Messages.format((String)"Value for identifier '{}' does not implement expected type '{}': '{}'", (Object[])new Object[]{id, id.getReferenceDataType().getSimpleName(), value}));
        }
    }

    public static ImmutableReferenceData empty() {
        return EMPTY;
    }

    @Override
    public <T> T queryValueOrNull(ReferenceDataId<T> id) {
        return (T)this.values.get(id);
    }

    @Override
    public ReferenceData combinedWith(ReferenceData other) {
        if (other instanceof ImmutableReferenceData) {
            ImmutableReferenceData otherData = (ImmutableReferenceData)other;
            HashMap combined = new HashMap();
            combined.putAll((Map<ReferenceDataId<?>, Object>)otherData.values);
            combined.putAll((Map<ReferenceDataId<?>, Object>)this.values);
            return new ImmutableReferenceData(combined);
        }
        return ReferenceData.super.combinedWith(other);
    }

    static final String msgValueNotFound(ReferenceDataId<?> id) {
        return Messages.format((String)"Reference data not found for identifier '{}' of type '{}'", (Object[])new Object[]{id, id.getClass().getSimpleName()});
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ImmutableReferenceData(Map<? extends ReferenceDataId<?>, ?> values) {
        JodaBeanUtils.notNull(values, (String)"values");
        this.values = ImmutableMap.copyOf(values);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableMap<ReferenceDataId<?>, Object> getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableReferenceData other = (ImmutableReferenceData)obj;
            return JodaBeanUtils.equal(this.values, other.values);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.values);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("ImmutableReferenceData{");
        buf.append("values").append('=').append(JodaBeanUtils.toString(this.values));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ImmutableReferenceData> {
        private Map<? extends ReferenceDataId<?>, ?> values = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    return this.values;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    this.values = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ImmutableReferenceData build() {
            return new ImmutableReferenceData(this.values);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("ImmutableReferenceData.Builder{");
            buf.append("values").append('=').append(JodaBeanUtils.toString(this.values));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableMap<ReferenceDataId<?>, Object>> values = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"values", ImmutableReferenceData.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"values"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    return this.values;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ImmutableReferenceData> builder() {
            return new Builder();
        }

        public Class<? extends ImmutableReferenceData> beanType() {
            return ImmutableReferenceData.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableMap<ReferenceDataId<?>, Object>> values() {
            return this.values;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    return ((ImmutableReferenceData)bean).getValues();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

