/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics;

import com.opengamma.strata.basics.CombinedReferenceData;
import com.opengamma.strata.basics.ImmutableReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.basics.ReferenceDataNotFoundException;
import com.opengamma.strata.basics.StandardReferenceData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public interface ReferenceData {
    public static ReferenceData of(Map<? extends ReferenceDataId<?>, ?> values) {
        HashMap combined = new HashMap();
        combined.putAll((Map<ReferenceDataId<?>, Object>)StandardReferenceData.MINIMAL.getValues());
        combined.putAll(values);
        return ImmutableReferenceData.of(combined);
    }

    public static ReferenceData standard() {
        return StandardReferenceData.STANDARD;
    }

    public static ReferenceData minimal() {
        return StandardReferenceData.MINIMAL;
    }

    public static ReferenceData empty() {
        return ImmutableReferenceData.empty();
    }

    default public boolean containsValue(ReferenceDataId<?> id) {
        return id.queryValueOrNull(this) != null;
    }

    default public <T> T getValue(ReferenceDataId<T> id) {
        T value = id.queryValueOrNull(this);
        if (value == null) {
            throw new ReferenceDataNotFoundException(ImmutableReferenceData.msgValueNotFound(id));
        }
        return value;
    }

    default public <T> Optional<T> findValue(ReferenceDataId<T> id) {
        T value = id.queryValueOrNull(this);
        return Optional.ofNullable(value);
    }

    public <T> T queryValueOrNull(ReferenceDataId<T> var1);

    default public ReferenceData combinedWith(ReferenceData other) {
        return new CombinedReferenceData(this, other);
    }
}

