/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ComparisonChain;
import com.google.common.net.PercentEscaper;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

@BeanDefinition(builderScope="private")
public final class StandardId
implements Comparable<StandardId>,
ImmutableBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final CharMatcher SCHEME_MATCHER = CharMatcher.inRange((char)'A', (char)'Z').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.is((char)':')).or(CharMatcher.is((char)'/')).or(CharMatcher.is((char)'+')).or(CharMatcher.is((char)'.')).or(CharMatcher.is((char)'=')).or(CharMatcher.is((char)'_')).or(CharMatcher.is((char)'-')).or(CharMatcher.is((char)'%')).precomputed();
    private static final CharMatcher VALUE_MATCHER = CharMatcher.inRange((char)' ', (char)'z').precomputed();
    private static final PercentEscaper SCHEME_ESCAPER = new PercentEscaper(":/+.=_-", false);
    @PropertyDefinition(validate="notNull")
    private final String scheme;
    @PropertyDefinition(validate="notNull")
    private final String value;
    private final transient int hashCode;

    public static StandardId of(String scheme, String value) {
        return new StandardId(scheme, value);
    }

    @FromString
    public static StandardId parse(String str) {
        int pos = ((String)ArgChecker.notNull((Object)str, (String)"str")).indexOf("~");
        if (pos < 0) {
            throw new IllegalArgumentException("Invalid identifier format: " + str);
        }
        return new StandardId(str.substring(0, pos), str.substring(pos + 1));
    }

    public static String encodeScheme(String scheme) {
        return SCHEME_ESCAPER.escape(scheme);
    }

    @ImmutableConstructor
    private StandardId(String scheme, String value) {
        ArgChecker.matches((CharMatcher)SCHEME_MATCHER, (int)1, (int)Integer.MAX_VALUE, (String)scheme, (String)"scheme", (String)"[A-Za-z0-9:/+.=_%-]+");
        ArgChecker.matches((CharMatcher)VALUE_MATCHER, (int)1, (int)Integer.MAX_VALUE, (String)value, (String)"value", (String)"[!-z][ -z]+");
        if (value.charAt(0) == ' ') {
            throw new IllegalArgumentException(Messages.format((String)"Invalid initial space in value '{}' must match regex '[!-z][ -z]+'", (Object)value));
        }
        this.scheme = scheme;
        this.value = value;
        this.hashCode = scheme.hashCode() ^ value.hashCode();
    }

    private Object readResolve() {
        return new StandardId(this.scheme, this.value);
    }

    @Override
    public int compareTo(StandardId other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.scheme), (Comparable)((Object)other.scheme)).compare((Comparable)((Object)this.value), (Comparable)((Object)other.value)).result();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StandardId) {
            StandardId other = (StandardId)obj;
            return this.scheme.equals(other.scheme) && this.value.equals(other.value);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @ToString
    public String toString() {
        return this.scheme + "~" + this.value;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getValue() {
        return this.value;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<StandardId> {
        private String scheme;
        private String value;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -907987547: {
                    return this.scheme;
                }
                case 111972721: {
                    return this.value;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -907987547: {
                    this.scheme = (String)newValue;
                    break;
                }
                case 111972721: {
                    this.value = (String)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public StandardId build() {
            return new StandardId(this.scheme, this.value);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("StandardId.Builder{");
            buf.append("scheme").append('=').append(JodaBeanUtils.toString((Object)this.scheme)).append(',').append(' ');
            buf.append("value").append('=').append(JodaBeanUtils.toString((Object)this.value));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> scheme = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"scheme", StandardId.class, String.class);
        private final MetaProperty<String> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", StandardId.class, String.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"scheme", "value"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -907987547: {
                    return this.scheme;
                }
                case 111972721: {
                    return this.value;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends StandardId> builder() {
            return new Builder();
        }

        public Class<? extends StandardId> beanType() {
            return StandardId.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> scheme() {
            return this.scheme;
        }

        public MetaProperty<String> value() {
            return this.value;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -907987547: {
                    return ((StandardId)bean).getScheme();
                }
                case 111972721: {
                    return ((StandardId)bean).getValue();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

