/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ImmutableReferenceData;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendars;
import java.util.HashMap;

final class StandardReferenceData {
    static final ImmutableReferenceData STANDARD;
    static final ImmutableReferenceData MINIMAL;

    private StandardReferenceData() {
    }

    static {
        HashMap<HolidayCalendarId, HolidayCalendar> map = new HashMap<HolidayCalendarId, HolidayCalendar>();
        for (HolidayCalendar cal : HolidayCalendars.extendedEnum().lookupAllNormalized().values()) {
            map.put(cal.getId(), cal);
        }
        STANDARD = ImmutableReferenceData.of(map);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)HolidayCalendars.NO_HOLIDAYS.getId(), (Object)HolidayCalendars.NO_HOLIDAYS);
        builder.put((Object)HolidayCalendars.SAT_SUN.getId(), (Object)HolidayCalendars.SAT_SUN);
        builder.put((Object)HolidayCalendars.FRI_SAT.getId(), (Object)HolidayCalendars.FRI_SAT);
        builder.put((Object)HolidayCalendars.THU_FRI.getId(), (Object)HolidayCalendars.THU_FRI);
        MINIMAL = ImmutableReferenceData.of(builder.build());
    }
}

