/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;

public final class StandardSchemes {
    public static final String OG_TICKER_SCHEME = "OG-Ticker";
    public static final String OG_ETD_SCHEME = "OG-ETD";
    public static final String OG_TRADE_SCHEME = "OG-Trade";
    public static final String OG_POSITION_SCHEME = "OG-Position";
    public static final String OG_SENSITIVITY_SCHEME = "OG-Sensitivity";
    public static final String OG_SECURITY_SCHEME = "OG-Security";
    public static final String OG_COUNTERPARTY = "OG-Counterparty";
    public static final String OG_PORTFOLIO = "OG-Portfolio";
    public static final String TICKER_SCHEME = "TICKER";
    public static final String TICMIC_SCHEME = "TICMIC";
    public static final String ISIN_SCHEME = "ISIN";
    public static final String CUSIP_SCHEME = "CUSIP";
    public static final String SEDOL_SCHEME = "SEDOL";
    public static final String WKN_SCHEME = "WKN";
    public static final String VALOR_SCHEME = "VALOR";
    public static final String RIC_SCHEME = "RIC";
    public static final String CHAIN_RIC_SCHEME = "CHAINRIC";
    public static final String BBG_SCHEME = "BBG";
    public static final String FIGI_SCHEME = "FIGI";
    public static final String LEI_SCHEME = "LEI";
    public static final String RED6_SCHEME = "RED6";
    public static final String RED9_SCHEME = "RED9";
    public static final String OPRA_SCHEME = "OPRA";
    public static final String OCC_SCHEME = "OCC";

    private StandardSchemes() {
    }

    public static StandardId createTicMic(String ticker, String exchangeMic) {
        ArgChecker.notNull((Object)ticker, (String)"ticker");
        ArgChecker.notNull((Object)exchangeMic, (String)"exchangeMic");
        ArgChecker.isTrue((exchangeMic.length() == 4 ? 1 : 0) != 0, (String)"MIC must have 4 characters, but was {}", (Object[])new Object[]{exchangeMic});
        return StandardId.of(TICMIC_SCHEME, ticker + '@' + exchangeMic);
    }

    public static Pair<String, String> splitTicMic(StandardId ticMic) {
        ArgChecker.notNull((Object)ticMic, (String)"ticMic");
        int splitPos = ticMic.getValue().lastIndexOf(64);
        if (splitPos < 0 || ticMic.getValue().length() < 6 || splitPos != ticMic.getValue().length() - 5) {
            throw new IllegalArgumentException("Invalid TICMIC identifier: " + ticMic);
        }
        String ticker = ticMic.getValue().substring(0, splitPos);
        String mic = ticMic.getValue().substring(splitPos + 1);
        return Pair.of((Object)ticker, (Object)mic);
    }
}

