/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.math.DoubleMath;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.Money;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Decimal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.function.UnaryOperator;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public class BigMoney
implements FxConvertible<BigMoney>,
Comparable<BigMoney>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Currency currency;
    private final Decimal amount;

    public static BigMoney zero(Currency currency) {
        return BigMoney.of(currency, Decimal.ZERO);
    }

    public static BigMoney of(CurrencyAmount currencyAmount) {
        return new BigMoney(currencyAmount.getCurrency(), Decimal.of((double)currencyAmount.getAmount()));
    }

    public static BigMoney of(Money money) {
        return new BigMoney(money.getCurrency(), money.getValue().decimal());
    }

    public static BigMoney of(Currency currency, double amount) {
        return new BigMoney(currency, Decimal.of((double)amount));
    }

    public static BigMoney of(Currency currency, BigDecimal amount) {
        return new BigMoney(currency, Decimal.of((BigDecimal)amount));
    }

    public static BigMoney of(Currency currency, Decimal amount) {
        return new BigMoney(currency, amount);
    }

    @FromString
    public static BigMoney parse(String amountStr) {
        ArgChecker.notNull((Object)amountStr, (String)"amountStr");
        List split = Splitter.on((char)' ').splitToList((CharSequence)amountStr);
        if (split.size() != 2) {
            throw new IllegalArgumentException("Unable to parse amount, invalid format: " + amountStr);
        }
        try {
            Currency cur = Currency.parse((String)split.get(0));
            return new BigMoney(cur, Decimal.of((String)((String)split.get(1))));
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Unable to parse amount: " + amountStr, ex);
        }
    }

    private BigMoney(Currency currency, Decimal amount) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        ArgChecker.notNull((Object)amount, (String)"amount");
        this.currency = currency;
        this.amount = amount.roundToScale(12, RoundingMode.HALF_UP);
    }

    public Currency getCurrency() {
        return this.currency;
    }

    @Deprecated
    public BigDecimal getAmount() {
        BigDecimal decimal = this.amount.toBigDecimal();
        int digits = this.currency.getMinorUnitDigits();
        if (decimal.scale() < digits) {
            return decimal.setScale(digits);
        }
        return decimal;
    }

    public Decimal getValue() {
        return this.amount;
    }

    public BigMoney plus(BigMoney amountToAdd) {
        ArgChecker.notNull((Object)amountToAdd, (String)"amountToAdd");
        ArgChecker.isTrue((boolean)amountToAdd.getCurrency().equals(this.currency), (String)"Unable to add amounts in different currencies");
        return new BigMoney(this.currency, this.amount.plus(amountToAdd.amount));
    }

    public BigMoney minus(BigMoney amountToSubtract) {
        ArgChecker.notNull((Object)amountToSubtract, (String)"amountToSubtract");
        ArgChecker.isTrue((boolean)amountToSubtract.getCurrency().equals(this.currency), (String)"Unable to subtract amounts in different currencies");
        return new BigMoney(this.currency, this.amount.minus(amountToSubtract.amount));
    }

    public BigMoney multipliedBy(long valueToMultiplyBy) {
        return new BigMoney(this.currency, this.amount.multipliedBy(valueToMultiplyBy));
    }

    public BigMoney map(UnaryOperator<Decimal> mapper) {
        ArgChecker.notNull(mapper, (String)"mapper");
        return new BigMoney(this.currency, (Decimal)mapper.apply(this.amount));
    }

    @Deprecated
    public BigMoney mapAmount(UnaryOperator<BigDecimal> mapper) {
        return this.map(decimal -> decimal.mapAsBigDecimal(mapper));
    }

    public boolean isGreaterThan(BigMoney otherAmount) {
        ArgChecker.notNull((Object)otherAmount, (String)"other");
        ArgChecker.isTrue((boolean)otherAmount.getCurrency().equals(this.currency), (String)"Unable to compare amounts in different currencies");
        return this.amount.isGreaterThan(otherAmount.getValue());
    }

    public boolean isGreaterThanEqualTo(BigMoney otherAmount) {
        ArgChecker.notNull((Object)otherAmount, (String)"otherAmount");
        ArgChecker.isTrue((boolean)otherAmount.getCurrency().equals(this.currency), (String)"Unable to compare amounts in different currencies");
        return this.amount.isGreaterThanEqualTo(otherAmount.getValue());
    }

    public boolean isLessThan(BigMoney otherAmount) {
        ArgChecker.notNull((Object)otherAmount, (String)"otherAmount");
        ArgChecker.isTrue((boolean)otherAmount.getCurrency().equals(this.currency), (String)"Unable to compare amounts in different currencies");
        return this.amount.isLessThan(otherAmount.getValue());
    }

    public boolean isLessThanEqualTo(BigMoney otherAmount) {
        ArgChecker.notNull((Object)otherAmount, (String)"otherAmount");
        ArgChecker.isTrue((boolean)otherAmount.getCurrency().equals(this.currency), (String)"Unable to compare amounts in different currencies");
        return this.amount.isLessThanEqualTo(otherAmount.getValue());
    }

    public BigMoney roundToScale(int desiredScale, RoundingMode roundingMode) {
        return new BigMoney(this.currency, this.amount.roundToScale(desiredScale, roundingMode));
    }

    public boolean isZero() {
        return this.amount.isZero();
    }

    public boolean isPositive() {
        return this.amount.unscaledValue() > 0L;
    }

    public boolean isNegative() {
        return this.amount.unscaledValue() < 0L;
    }

    public BigMoney negated() {
        if (this.isZero()) {
            return this;
        }
        return new BigMoney(this.currency, this.amount.negated());
    }

    public BigMoney positive() {
        return this.isNegative() ? this.negated() : this;
    }

    public BigMoney negative() {
        return this.isPositive() ? this.negated() : this;
    }

    public CurrencyAmount toCurrencyAmount() {
        return CurrencyAmount.of(this.currency, this.amount.doubleValue());
    }

    public Money toMoney() {
        return Money.of(this);
    }

    public BigMoney convertedTo(Currency resultCurrency, BigDecimal fxRate) {
        return this.convertedTo(resultCurrency, Decimal.of((BigDecimal)fxRate));
    }

    public BigMoney convertedTo(Currency resultCurrency, Decimal fxRate) {
        if (this.currency.equals(resultCurrency)) {
            if (DoubleMath.fuzzyEquals((double)fxRate.doubleValue(), (double)1.0, (double)1.0E-8)) {
                return this;
            }
            throw new IllegalArgumentException("FX rate must be 1 when no conversion required");
        }
        return BigMoney.of(resultCurrency, this.amount.multipliedBy(fxRate));
    }

    @Override
    public BigMoney convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        if (this.currency.equals(resultCurrency)) {
            return this;
        }
        double converted = rateProvider.convert(this.amount.doubleValue(), this.currency, resultCurrency);
        return BigMoney.of(resultCurrency, converted);
    }

    @Override
    public int compareTo(BigMoney other) {
        return ComparisonChain.start().compare((Comparable)this.currency, (Comparable)other.currency).compare((Comparable)this.amount, (Comparable)other.amount).result();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BigMoney other = (BigMoney)obj;
            return this.currency.equals(other.currency) && this.amount.equals((Object)other.amount);
        }
        return false;
    }

    public int hashCode() {
        return this.currency.hashCode() * 31 + this.amount.hashCode();
    }

    @ToString
    public String toString() {
        return this.currency + " " + this.amount.formatAtLeast(this.currency.getMinorUnitDigits());
    }
}

