/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.math.DoubleMath;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FxRate
implements FxRateProvider,
ImmutableBean,
Serializable {
    private static final Pattern REGEX_FORMAT = Pattern.compile("([A-Z]{3})[/]([A-Z]{3})[ ]([0-9+.-]+)");
    @PropertyDefinition(validate="notNull")
    private final CurrencyPair pair;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero", get="private")
    private final double rate;
    private static final long serialVersionUID = 1L;

    public static FxRate of(Currency base, Currency counter, double rate) {
        return new FxRate(CurrencyPair.of(base, counter), rate);
    }

    public static FxRate of(CurrencyPair pair, double rate) {
        return new FxRate(pair, rate);
    }

    public static FxRate parse(String rateStr) {
        ArgChecker.notNull((Object)rateStr, (String)"rateStr");
        Matcher matcher = REGEX_FORMAT.matcher(rateStr.toUpperCase(Locale.ENGLISH));
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid rate: " + rateStr);
        }
        try {
            Currency base = Currency.parse(matcher.group(1));
            Currency counter = Currency.parse(matcher.group(2));
            double rate = Double.parseDouble(matcher.group(3));
            return new FxRate(CurrencyPair.of(base, counter), rate);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Unable to parse rate: " + rateStr, ex);
        }
    }

    @ImmutableValidator
    private void validate() {
        if (this.pair.getBase().equals(this.pair.getCounter()) && this.rate != 1.0) {
            throw new IllegalArgumentException("Conversion rate between identical currencies must be one");
        }
    }

    public FxRate inverse() {
        return new FxRate(this.pair.inverse(), 1.0 / this.rate);
    }

    @Override
    public double fxRate(Currency baseCurrency, Currency counterCurrency) {
        if (baseCurrency.equals(counterCurrency)) {
            return 1.0;
        }
        if (baseCurrency.equals(this.pair.getBase()) && counterCurrency.equals(this.pair.getCounter())) {
            return this.rate;
        }
        if (counterCurrency.equals(this.pair.getBase()) && baseCurrency.equals(this.pair.getCounter())) {
            return 1.0 / this.rate;
        }
        throw new IllegalArgumentException(Messages.format((String)"No FX rate found for {}/{}", (Object[])new Object[]{baseCurrency, counterCurrency}));
    }

    public FxRate crossRate(FxRate other) {
        return this.pair.cross(other.pair).map(cross -> FxRate.computeCross(this, other, cross)).orElseThrow(() -> new IllegalArgumentException(Messages.format((String)"Unable to cross when no unique common currency: {} and {}", (Object[])new Object[]{this.pair, other.pair})));
    }

    private static FxRate computeCross(FxRate fx1, FxRate fx2, CurrencyPair crossPairAC) {
        Currency currA = crossPairAC.getBase();
        Currency currC = crossPairAC.getCounter();
        boolean crossBaseCurrencyInFx1 = fx1.pair.contains(currA);
        FxRate fxABorBA = crossBaseCurrencyInFx1 ? fx1 : fx2;
        FxRate fxBCorCB = crossBaseCurrencyInFx1 ? fx2 : fx1;
        double rateAB = fxABorBA.getPair().getBase().equals(currA) ? fxABorBA.rate : 1.0 / fxABorBA.rate;
        double rateBC = fxBCorCB.getPair().getCounter().equals(currC) ? fxBCorCB.rate : 1.0 / fxBCorCB.rate;
        return FxRate.of(crossPairAC, rateAB * rateBC);
    }

    public FxRate toConventional() {
        return this.pair.isConventional() ? this : FxRate.of(this.pair.toConventional(), 1.0 / this.rate);
    }

    public String toString() {
        return this.pair + " " + (DoubleMath.isMathematicalInteger((double)this.rate) ? Long.toString((long)this.rate) : Double.toString(this.rate));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FxRate(CurrencyPair pair, double rate) {
        JodaBeanUtils.notNull((Object)pair, (String)"pair");
        ArgChecker.notNegativeOrZero((double)rate, (String)"rate");
        this.pair = pair;
        this.rate = rate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurrencyPair getPair() {
        return this.pair;
    }

    private double getRate() {
        return this.rate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxRate other = (FxRate)obj;
            return JodaBeanUtils.equal((Object)this.pair, (Object)other.pair) && JodaBeanUtils.equal((double)this.rate, (double)other.rate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.pair);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.rate);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxRate> {
        private CurrencyPair pair;
        private double rate;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3433178: {
                    return this.pair;
                }
                case 3493088: {
                    return this.rate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3433178: {
                    this.pair = (CurrencyPair)newValue;
                    break;
                }
                case 3493088: {
                    this.rate = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxRate build() {
            return new FxRate(this.pair, this.rate);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("FxRate.Builder{");
            buf.append("pair").append('=').append(JodaBeanUtils.toString((Object)this.pair)).append(',').append(' ');
            buf.append("rate").append('=').append(JodaBeanUtils.toString((Object)this.rate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyPair> pair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"pair", FxRate.class, CurrencyPair.class);
        private final MetaProperty<Double> rate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rate", FxRate.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"pair", "rate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3433178: {
                    return this.pair;
                }
                case 3493088: {
                    return this.rate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxRate> builder() {
            return new Builder();
        }

        public Class<? extends FxRate> beanType() {
            return FxRate.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyPair> pair() {
            return this.pair;
        }

        public MetaProperty<Double> rate() {
            return this.rate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3433178: {
                    return ((FxRate)bean).getPair();
                }
                case 3493088: {
                    return ((FxRate)bean).getRate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

