/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.base.Suppliers;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import java.util.function.Supplier;

class LazyFxRateProvider
implements FxRateProvider {
    private final Supplier<FxRateProvider> target;

    LazyFxRateProvider(Supplier<FxRateProvider> target) {
        ArgChecker.notNull(target, (String)"target");
        this.target = Suppliers.memoize(target::get);
    }

    @Override
    public double convert(double amount, Currency fromCurrency, Currency toCurrency) {
        if (fromCurrency.equals(toCurrency)) {
            return amount;
        }
        return this.target.get().convert(amount, fromCurrency, toCurrency);
    }

    @Override
    public double fxRate(Currency baseCurrency, Currency counterCurrency) {
        return this.fxRate(CurrencyPair.of(baseCurrency, counterCurrency));
    }

    @Override
    public double fxRate(CurrencyPair currencyPair) {
        if (currencyPair.getBase().equals(currencyPair.getCounter())) {
            return 1.0;
        }
        return this.target.get().fxRate(currencyPair);
    }
}

