/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.math.DoubleMath;
import com.opengamma.strata.basics.currency.BigMoney;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Decimal;
import com.opengamma.strata.collect.FixedScaleDecimal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.UnaryOperator;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public class Money
implements FxConvertible<Money>,
Comparable<Money>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Currency currency;
    private final Decimal amount;

    public static Money zero(Currency currency) {
        return Money.of(currency, Decimal.ZERO);
    }

    public static Money of(CurrencyAmount currencyAmount) {
        return new Money(currencyAmount.getCurrency(), Decimal.of((double)currencyAmount.getAmount()));
    }

    public static Money of(BigMoney money) {
        return new Money(money.getCurrency(), money.getValue());
    }

    public static Money of(Currency currency, double amount) {
        return new Money(currency, Decimal.of((double)amount));
    }

    public static Money of(Currency currency, BigDecimal amount) {
        return new Money(currency, Decimal.of((BigDecimal)amount));
    }

    public static Money of(Currency currency, Decimal amount) {
        return new Money(currency, amount);
    }

    @FromString
    public static Money parse(String amountStr) {
        ArgChecker.notNull((Object)amountStr, (String)"amountStr");
        List split = Splitter.on((char)' ').splitToList((CharSequence)amountStr);
        if (split.size() != 2) {
            throw new IllegalArgumentException("Unable to parse amount, invalid format: " + amountStr);
        }
        try {
            Currency cur = Currency.parse((String)split.get(0));
            return new Money(cur, Decimal.of((String)((String)split.get(1))));
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Unable to parse amount: " + amountStr, ex);
        }
    }

    private Money(Currency currency, Decimal amount) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        ArgChecker.notNull((Object)amount, (String)"amount");
        this.currency = currency;
        this.amount = currency.roundMinorUnits(amount);
    }

    public Currency getCurrency() {
        return this.currency;
    }

    @Deprecated
    public BigDecimal getAmount() {
        return this.amount.toBigDecimal().setScale(this.currency.getMinorUnitDigits());
    }

    public FixedScaleDecimal getValue() {
        return this.amount.toFixedScale(this.currency.getMinorUnitDigits());
    }

    public Money plus(Money amountToAdd) {
        ArgChecker.notNull((Object)amountToAdd, (String)"amountToAdd");
        ArgChecker.isTrue((boolean)amountToAdd.getCurrency().equals(this.currency), (String)"Unable to add amounts in different currencies");
        return new Money(this.currency, this.amount.plus(amountToAdd.amount));
    }

    public Money minus(Money amountToSubtract) {
        ArgChecker.notNull((Object)amountToSubtract, (String)"amountToSubtract");
        ArgChecker.isTrue((boolean)amountToSubtract.getCurrency().equals(this.currency), (String)"Unable to subtract amounts in different currencies");
        return new Money(this.currency, this.amount.minus(amountToSubtract.amount));
    }

    public Money multipliedBy(long valueToMultiplyBy) {
        return new Money(this.currency, this.amount.multipliedBy(valueToMultiplyBy));
    }

    public Money map(UnaryOperator<Decimal> mapper) {
        ArgChecker.notNull(mapper, (String)"mapper");
        return new Money(this.currency, (Decimal)mapper.apply(this.amount));
    }

    @Deprecated
    public Money mapAmount(UnaryOperator<BigDecimal> mapper) {
        return this.map(decimal -> decimal.mapAsBigDecimal(mapper));
    }

    public boolean isZero() {
        return this.amount.isZero();
    }

    public boolean isPositive() {
        return this.amount.unscaledValue() > 0L;
    }

    public boolean isNegative() {
        return this.amount.unscaledValue() < 0L;
    }

    public Money negated() {
        if (this.isZero()) {
            return this;
        }
        return new Money(this.currency, this.amount.negated());
    }

    public Money positive() {
        return this.isNegative() ? this.negated() : this;
    }

    public Money negative() {
        return this.isPositive() ? this.negated() : this;
    }

    public CurrencyAmount toCurrencyAmount() {
        return CurrencyAmount.of(this.currency, this.amount.doubleValue());
    }

    public BigMoney toBigMoney() {
        return BigMoney.of(this);
    }

    public Money convertedTo(Currency resultCurrency, BigDecimal fxRate) {
        return this.convertedTo(resultCurrency, Decimal.of((BigDecimal)fxRate));
    }

    public Money convertedTo(Currency resultCurrency, Decimal fxRate) {
        if (this.currency.equals(resultCurrency)) {
            if (DoubleMath.fuzzyEquals((double)fxRate.doubleValue(), (double)1.0, (double)1.0E-8)) {
                return this;
            }
            throw new IllegalArgumentException("FX rate must be 1 when no conversion required");
        }
        return Money.of(resultCurrency, this.amount.multipliedBy(fxRate));
    }

    @Override
    public Money convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        if (this.currency.equals(resultCurrency)) {
            return this;
        }
        double converted = rateProvider.convert(this.amount.doubleValue(), this.currency, resultCurrency);
        return Money.of(resultCurrency, converted);
    }

    @Override
    public int compareTo(Money other) {
        return ComparisonChain.start().compare((Comparable)this.currency, (Comparable)other.currency).compare((Comparable)this.amount, (Comparable)other.amount).result();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Money other = (Money)obj;
            return this.currency.equals(other.currency) && this.amount.equals((Object)other.amount);
        }
        return false;
    }

    public int hashCode() {
        return this.currency.hashCode() * 31 + this.amount.hashCode();
    }

    @ToString
    public String toString() {
        return this.currency + " " + this.amount.formatAtLeast(this.currency.getMinorUnitDigits());
    }
}

