/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.currency;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyAmountArray;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.IntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class MultiCurrencyAmountArray
implements FxConvertible<CurrencyAmountArray>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNegative")
    private final int size;
    @PropertyDefinition(validate="notNull")
    private final ImmutableSortedMap<Currency, DoubleArray> values;
    private static final long serialVersionUID = 1L;

    public static MultiCurrencyAmountArray of(MultiCurrencyAmount ... amounts) {
        return MultiCurrencyAmountArray.of(Arrays.asList(amounts));
    }

    public static MultiCurrencyAmountArray of(List<MultiCurrencyAmount> amounts) {
        int size = amounts.size();
        HashMap<Currency, double[]> valueMap = new HashMap<Currency, double[]>();
        for (int i = 0; i < size; ++i) {
            MultiCurrencyAmount multiCurrencyAmount = amounts.get(i);
            for (CurrencyAmount currencyAmount : multiCurrencyAmount.getAmounts()) {
                double[] currencyValues = valueMap.computeIfAbsent(currencyAmount.getCurrency(), ccy -> new double[size]);
                currencyValues[i] = currencyAmount.getAmount();
            }
        }
        ImmutableMap doubleArrayMap = MapStream.of(valueMap).mapValues(v -> DoubleArray.ofUnsafe((double[])v)).toMap();
        return new MultiCurrencyAmountArray(size, (Map<Currency, DoubleArray>)doubleArrayMap);
    }

    public static MultiCurrencyAmountArray of(int size, IntFunction<MultiCurrencyAmount> valueFunction) {
        HashMap<Currency, double[]> map = new HashMap<Currency, double[]>();
        for (int i = 0; i < size; ++i) {
            MultiCurrencyAmount mca = valueFunction.apply(i);
            for (CurrencyAmount ca : mca.getAmounts()) {
                double[] array2 = map.computeIfAbsent(ca.getCurrency(), c -> new double[size]);
                array2[i] = ca.getAmount();
            }
        }
        return new MultiCurrencyAmountArray(size, (Map<Currency, DoubleArray>)MapStream.of(map).mapValues(array -> DoubleArray.ofUnsafe((double[])array)).toMap());
    }

    public static MultiCurrencyAmountArray of(Map<Currency, DoubleArray> values) {
        values.values().stream().reduce((a1, a2) -> MultiCurrencyAmountArray.checkSize(a1, a2));
        int size = values.isEmpty() ? 0 : values.values().iterator().next().size();
        return new MultiCurrencyAmountArray(size, values);
    }

    private static DoubleArray checkSize(DoubleArray array1, DoubleArray array2) {
        if (array1.size() != array2.size()) {
            throw new IllegalArgumentException(Messages.format((String)"Arrays must have the same size but found sizes {} and {}", (Object[])new Object[]{array1.size(), array2.size()}));
        }
        return array1;
    }

    @ImmutableConstructor
    private MultiCurrencyAmountArray(int size, Map<Currency, DoubleArray> values) {
        this.values = ImmutableSortedMap.copyOf(values);
        this.size = size;
    }

    private Object readResolve() {
        this.values.values().stream().reduce((a1, a2) -> MultiCurrencyAmountArray.checkSize(a1, a2));
        return this;
    }

    public Set<Currency> getCurrencies() {
        return this.values.keySet();
    }

    public DoubleArray getValues(Currency currency) {
        DoubleArray currencyValues = (DoubleArray)this.values.get((Object)currency);
        if (currencyValues == null) {
            throw new IllegalArgumentException("No values available for " + currency);
        }
        return currencyValues;
    }

    public int size() {
        return this.size;
    }

    public MultiCurrencyAmount get(int index) {
        List<CurrencyAmount> currencyAmounts = this.values.keySet().stream().map(ccy -> CurrencyAmount.of(ccy, ((DoubleArray)this.values.get(ccy)).get(index))).collect(Collectors.toList());
        return MultiCurrencyAmount.of(currencyAmounts);
    }

    public Stream<MultiCurrencyAmount> stream() {
        return IntStream.range(0, this.size).mapToObj(this::get);
    }

    @Override
    public CurrencyAmountArray convertedTo(Currency resultCurrency, FxRateProvider fxRateProvider) {
        double[] singleCurrencyValues = new double[this.size];
        for (Map.Entry entry : this.values.entrySet()) {
            Currency currency = (Currency)entry.getKey();
            DoubleArray currencyValues = (DoubleArray)entry.getValue();
            for (int i = 0; i < this.size; ++i) {
                int n = i;
                singleCurrencyValues[n] = singleCurrencyValues[n] + currencyValues.get(i) * fxRateProvider.fxRate(currency, resultCurrency);
            }
        }
        return CurrencyAmountArray.of(resultCurrency, DoubleArray.ofUnsafe((double[])singleCurrencyValues));
    }

    public MultiCurrencyAmountArray plus(MultiCurrencyAmountArray other) {
        if (other.size() != this.size) {
            throw new IllegalArgumentException(Messages.format((String)"Sizes must be equal, this size is {}, other size is {}", (Object[])new Object[]{this.size, other.size()}));
        }
        Map<Currency, DoubleArray> addedValues = Stream.concat(this.values.entrySet().stream(), other.values.entrySet().stream()).collect(Collectors.toMap(e -> (Currency)e.getKey(), e -> (DoubleArray)e.getValue(), (arr1, arr2) -> arr1.plus(arr2)));
        return MultiCurrencyAmountArray.of(addedValues);
    }

    public MultiCurrencyAmountArray plus(MultiCurrencyAmount amount) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Currency currency : Sets.union((Set)this.values.keySet(), amount.getCurrencies())) {
            DoubleArray array = (DoubleArray)this.values.get((Object)currency);
            if (array == null) {
                builder.put((Object)currency, (Object)DoubleArray.filled((int)this.size, (double)amount.getAmount(currency).getAmount()));
                continue;
            }
            if (!amount.contains(currency)) {
                builder.put((Object)currency, (Object)array);
                continue;
            }
            builder.put((Object)currency, (Object)array.plus(amount.getAmount(currency).getAmount()));
        }
        return MultiCurrencyAmountArray.of((Map<Currency, DoubleArray>)builder.build());
    }

    public MultiCurrencyAmountArray minus(MultiCurrencyAmountArray other) {
        if (other.size() != this.size) {
            throw new IllegalArgumentException(Messages.format((String)"Sizes must be equal, this size is {}, other size is {}", (Object[])new Object[]{this.size, other.size()}));
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Currency currency : Sets.union((Set)this.values.keySet(), (Set)other.values.keySet())) {
            DoubleArray array = (DoubleArray)this.values.get((Object)currency);
            DoubleArray otherArray = (DoubleArray)other.values.get((Object)currency);
            if (otherArray == null) {
                builder.put((Object)currency, (Object)array);
                continue;
            }
            if (array == null) {
                builder.put((Object)currency, (Object)otherArray.multipliedBy(-1.0));
                continue;
            }
            builder.put((Object)currency, (Object)array.minus(otherArray));
        }
        return MultiCurrencyAmountArray.of((Map<Currency, DoubleArray>)builder.build());
    }

    public MultiCurrencyAmountArray minus(MultiCurrencyAmount amount) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Currency currency : Sets.union((Set)this.values.keySet(), amount.getCurrencies())) {
            DoubleArray array = (DoubleArray)this.values.get((Object)currency);
            if (array == null) {
                builder.put((Object)currency, (Object)DoubleArray.filled((int)this.size, (double)(-amount.getAmount(currency).getAmount())));
                continue;
            }
            if (!amount.contains(currency)) {
                builder.put((Object)currency, (Object)array);
                continue;
            }
            builder.put((Object)currency, (Object)array.minus(amount.getAmount(currency).getAmount()));
        }
        return MultiCurrencyAmountArray.of((Map<Currency, DoubleArray>)builder.build());
    }

    public static MultiCurrencyAmountArray total(Iterable<CurrencyAmountArray> arrays) {
        return Guavate.stream(arrays).collect(MultiCurrencyAmountArray.toMultiCurrencyAmountArray());
    }

    public static Collector<CurrencyAmountArray, ?, MultiCurrencyAmountArray> toMultiCurrencyAmountArray() {
        return Collector.of(HashMap::new, (A map, T ca) -> map.merge(ca.getCurrency(), ca, CurrencyAmountArray::plus), (map1, map2) -> {
            map2.values().forEach(ca2 -> map1.merge(ca2.getCurrency(), ca2, CurrencyAmountArray::plus));
            return map1;
        }, (A map) -> {
            ImmutableMap currencyArrayMap = MapStream.of((Map)map).mapValues(caa -> caa.getValues()).toMap();
            return MultiCurrencyAmountArray.of((Map<Currency, DoubleArray>)currencyArrayMap);
        }, Collector.Characteristics.UNORDERED);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public int getSize() {
        return this.size;
    }

    public ImmutableSortedMap<Currency, DoubleArray> getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            MultiCurrencyAmountArray other = (MultiCurrencyAmountArray)obj;
            return this.size == other.size && JodaBeanUtils.equal(this.values, other.values);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.size);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.values);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("MultiCurrencyAmountArray{");
        buf.append("size").append('=').append(JodaBeanUtils.toString((Object)this.size)).append(',').append(' ');
        buf.append("values").append('=').append(JodaBeanUtils.toString(this.values));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<MultiCurrencyAmountArray> {
        private int size;
        private SortedMap<Currency, DoubleArray> values = ImmutableSortedMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3530753: {
                    return this.size;
                }
                case -823812830: {
                    return this.values;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3530753: {
                    this.size = (Integer)newValue;
                    break;
                }
                case -823812830: {
                    this.values = (SortedMap)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public MultiCurrencyAmountArray build() {
            return new MultiCurrencyAmountArray(this.size, this.values);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("MultiCurrencyAmountArray.Builder{");
            buf.append("size").append('=').append(JodaBeanUtils.toString((Object)this.size)).append(',').append(' ');
            buf.append("values").append('=').append(JodaBeanUtils.toString(this.values));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Integer> size = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"size", MultiCurrencyAmountArray.class, Integer.TYPE);
        private final MetaProperty<ImmutableSortedMap<Currency, DoubleArray>> values = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"values", MultiCurrencyAmountArray.class, ImmutableSortedMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"size", "values"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3530753: {
                    return this.size;
                }
                case -823812830: {
                    return this.values;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends MultiCurrencyAmountArray> builder() {
            return new Builder();
        }

        public Class<? extends MultiCurrencyAmountArray> beanType() {
            return MultiCurrencyAmountArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Integer> size() {
            return this.size;
        }

        public MetaProperty<ImmutableSortedMap<Currency, DoubleArray>> values() {
            return this.values;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3530753: {
                    return ((MultiCurrencyAmountArray)bean).getSize();
                }
                case -823812830: {
                    return ((MultiCurrencyAmountArray)bean).getValues();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

