/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class AdjustableDates
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<LocalDate> unadjusted;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment adjustment;
    private static final long serialVersionUID = 1L;

    public static AdjustableDates of(LocalDate firstDate, LocalDate ... remainingDates) {
        return new AdjustableDates((List<LocalDate>)Guavate.list((Object)firstDate, (Object[])remainingDates), BusinessDayAdjustment.NONE);
    }

    public static AdjustableDates of(List<LocalDate> dates) {
        return new AdjustableDates((List<LocalDate>)ImmutableList.copyOf(dates), BusinessDayAdjustment.NONE);
    }

    public static AdjustableDates of(BusinessDayAdjustment adjustment, LocalDate firstDate, LocalDate ... remainingDates) {
        return new AdjustableDates((List<LocalDate>)Guavate.list((Object)firstDate, (Object[])remainingDates), adjustment);
    }

    public static AdjustableDates of(BusinessDayAdjustment adjustment, List<LocalDate> dates) {
        return new AdjustableDates((List<LocalDate>)ImmutableList.copyOf(dates), adjustment);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)Ordering.natural().isStrictlyOrdered(this.unadjusted), (String)"Dates must be in order and without duplicates");
    }

    public ImmutableList<LocalDate> adjusted(ReferenceData refData) {
        DateAdjuster adjuster = this.adjustment.resolve(refData);
        return (ImmutableList)this.unadjusted.stream().map(adjuster::adjust).distinct().collect(Guavate.toImmutableList());
    }

    public ImmutableList<AdjustableDate> toAdjustableDateList() {
        return (ImmutableList)this.unadjusted.stream().map(date -> AdjustableDate.of(date, this.adjustment)).collect(Guavate.toImmutableList());
    }

    public String toString() {
        if (this.adjustment.equals(BusinessDayAdjustment.NONE)) {
            return this.unadjusted.toString();
        }
        return new StringBuilder(64).append(this.unadjusted).append(" adjusted by ").append(this.adjustment).toString();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private AdjustableDates(List<LocalDate> unadjusted, BusinessDayAdjustment adjustment) {
        JodaBeanUtils.notEmpty(unadjusted, (String)"unadjusted");
        JodaBeanUtils.notNull((Object)adjustment, (String)"adjustment");
        this.unadjusted = ImmutableList.copyOf(unadjusted);
        this.adjustment = adjustment;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<LocalDate> getUnadjusted() {
        return this.unadjusted;
    }

    public BusinessDayAdjustment getAdjustment() {
        return this.adjustment;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            AdjustableDates other = (AdjustableDates)obj;
            return JodaBeanUtils.equal(this.unadjusted, other.unadjusted) && JodaBeanUtils.equal((Object)this.adjustment, (Object)other.adjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.unadjusted);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.adjustment);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<AdjustableDates> {
        private List<LocalDate> unadjusted = ImmutableList.of();
        private BusinessDayAdjustment adjustment;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 482476551: {
                    return this.unadjusted;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 482476551: {
                    this.unadjusted = (List)newValue;
                    break;
                }
                case 1977085293: {
                    this.adjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public AdjustableDates build() {
            return new AdjustableDates(this.unadjusted, this.adjustment);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("AdjustableDates.Builder{");
            buf.append("unadjusted").append('=').append(JodaBeanUtils.toString(this.unadjusted)).append(',').append(' ');
            buf.append("adjustment").append('=').append(JodaBeanUtils.toString((Object)this.adjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<LocalDate>> unadjusted = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjusted", AdjustableDates.class, ImmutableList.class);
        private final MetaProperty<BusinessDayAdjustment> adjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"adjustment", AdjustableDates.class, BusinessDayAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"unadjusted", "adjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 482476551: {
                    return this.unadjusted;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends AdjustableDates> builder() {
            return new Builder();
        }

        public Class<? extends AdjustableDates> beanType() {
            return AdjustableDates.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<LocalDate>> unadjusted() {
            return this.unadjusted;
        }

        public MetaProperty<BusinessDayAdjustment> adjustment() {
            return this.adjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 482476551: {
                    return ((AdjustableDates)bean).getUnadjusted();
                }
                case 1977085293: {
                    return ((AdjustableDates)bean).getAdjustment();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

