/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.Business252DayCount;
import com.opengamma.strata.basics.date.DayCounts;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import java.time.LocalDate;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface DayCount
extends Named {
    @FromString
    public static DayCount of(String uniqueName) {
        return (DayCount)DayCount.extendedEnum().lookup(uniqueName);
    }

    public static DayCount ofBus252(HolidayCalendarId calendar) {
        return Business252DayCount.INSTANCE.of(calendar.resolve(ReferenceData.standard()));
    }

    public static ExtendedEnum<DayCount> extendedEnum() {
        return DayCounts.ENUM_LOOKUP;
    }

    default public double yearFraction(LocalDate firstDate, LocalDate secondDate) {
        return this.yearFraction(firstDate, secondDate, DayCounts.SIMPLE_SCHEDULE_INFO);
    }

    public double yearFraction(LocalDate var1, LocalDate var2, ScheduleInfo var3);

    default public double relativeYearFraction(LocalDate firstDate, LocalDate secondDate) {
        return this.relativeYearFraction(firstDate, secondDate, DayCounts.SIMPLE_SCHEDULE_INFO);
    }

    default public double relativeYearFraction(LocalDate firstDate, LocalDate secondDate, ScheduleInfo scheduleInfo) {
        if (secondDate.isBefore(firstDate)) {
            return -this.yearFraction(secondDate, firstDate, scheduleInfo);
        }
        return this.yearFraction(firstDate, secondDate, scheduleInfo);
    }

    public int days(LocalDate var1, LocalDate var2);

    @ToString
    public String getName();

    public static interface ScheduleInfo {
        default public LocalDate getStartDate() {
            throw new UnsupportedOperationException("The start date of the schedule is required");
        }

        default public LocalDate getEndDate() {
            throw new UnsupportedOperationException("The end date of the schedule is required");
        }

        default public LocalDate getPeriodEndDate(LocalDate date) {
            throw new UnsupportedOperationException("The end date of the schedule period is required");
        }

        default public Frequency getFrequency() {
            throw new UnsupportedOperationException("The frequency of the schedule is required");
        }

        default public boolean isEndOfMonthConvention() {
            return true;
        }
    }
}

