/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.ImmutableHolidayCalendar;
import com.opengamma.strata.collect.io.ResourceLocator;
import com.opengamma.strata.collect.named.NamedLookup;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

final class GlobalHolidayCalendarLookup
implements NamedLookup<HolidayCalendar> {
    public static final GlobalHolidayCalendarLookup INSTANCE = new GlobalHolidayCalendarLookup();
    private final ImmutableMap<String, HolidayCalendar> map;

    private GlobalHolidayCalendarLookup() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ResourceLocator locator = ResourceLocator.ofClasspath((String)"com/opengamma/strata/basics/date/GlobalHolidayCalendars.bin");
        try (InputStream fis = locator.getByteSource().openStream();
             DataInputStream in = new DataInputStream(fis);){
            if (in.readByte() != 72 || in.readByte() != 67 || in.readByte() != 97 || in.readByte() != 108) {
                System.err.println("ERROR: Corrupt holiday calendar data file");
            } else {
                int calSize = in.readShort();
                for (int i = 0; i < calSize; ++i) {
                    ImmutableHolidayCalendar cal = ImmutableHolidayCalendar.readExternal(in);
                    builder.put((Object)cal.getId().getName(), (Object)cal);
                }
            }
        }
        catch (IOException ex) {
            System.err.println("ERROR: Unable to parse holiday calendar data file: " + ex.getMessage());
            ex.printStackTrace();
        }
        this.map = builder.build();
    }

    public ImmutableMap<String, HolidayCalendar> lookupAll() {
        return this.map;
    }
}

