/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.time.Period;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class MarketTenor
implements Comparable<MarketTenor>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MARKET_CONVENTION_LAG = Integer.MAX_VALUE;
    public static final MarketTenor ON = new MarketTenor("ON", Tenor.ofDays(1), 0);
    public static final MarketTenor TN = new MarketTenor("TN", Tenor.ofDays(1), 1);
    public static final MarketTenor SN = new MarketTenor("SN", Tenor.ofDays(1), Integer.MAX_VALUE);
    public static final MarketTenor SW = new MarketTenor("SW", Tenor.ofWeeks(1), Integer.MAX_VALUE);
    private final String code;
    private final Tenor tenor;
    private final int spotLagIndicator;

    public static MarketTenor ofSpot(Tenor tenor) {
        if (tenor.getPeriod().equals(Period.ofDays(1))) {
            return SN;
        }
        if (tenor.getPeriod().equals(Period.ofDays(7))) {
            return SW;
        }
        return new MarketTenor(tenor.toString(), tenor, Integer.MAX_VALUE);
    }

    public static MarketTenor ofSpotDays(int days) {
        if (days == 1) {
            return SN;
        }
        if (days == 7) {
            return SW;
        }
        Tenor tenor = Tenor.ofDays(days);
        return new MarketTenor(tenor.toString(), tenor, Integer.MAX_VALUE);
    }

    public static MarketTenor ofSpotMonths(int months) {
        Tenor tenor = Tenor.ofMonths(months);
        return new MarketTenor(tenor.toString(), tenor, Integer.MAX_VALUE);
    }

    public static MarketTenor ofSpotYears(int years) {
        Tenor tenor = Tenor.ofYears(years);
        return new MarketTenor(tenor.toString(), tenor, Integer.MAX_VALUE);
    }

    @FromString
    public static MarketTenor parse(String toParse) {
        ArgChecker.notEmpty((String)toParse, (String)"toParse");
        switch (toParse) {
            case "ON": {
                return ON;
            }
            case "TN": {
                return TN;
            }
            case "SN": {
                return SN;
            }
            case "SW": {
                return SW;
            }
        }
        return MarketTenor.ofSpot(Tenor.parse(toParse));
    }

    private MarketTenor(String code, Tenor tenor, int spotLagIndicator) {
        ArgChecker.notNull((Object)code, (String)"code");
        ArgChecker.notNull((Object)tenor, (String)"tenor");
        this.code = code;
        this.tenor = tenor;
        this.spotLagIndicator = spotLagIndicator;
    }

    private Object readResolve() {
        return MarketTenor.parse(this.code);
    }

    public String getCode() {
        return this.code;
    }

    public Tenor getTenor() {
        return this.tenor;
    }

    public boolean isNonStandardSpotLag() {
        return this.spotLagIndicator != Integer.MAX_VALUE;
    }

    public DaysAdjustment adjustSpotLag(DaysAdjustment marketConventionalSpotLag) {
        if (this.isNonStandardSpotLag()) {
            return DaysAdjustment.ofBusinessDays(this.spotLagIndicator, marketConventionalSpotLag.getResultCalendar());
        }
        return marketConventionalSpotLag;
    }

    @Override
    public int compareTo(MarketTenor other) {
        if (this.isNonStandardSpotLag() || other.isNonStandardSpotLag()) {
            return Integer.compare(this.spotLagIndicator, other.spotLagIndicator);
        }
        return this.tenor.compareTo(other.tenor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MarketTenor other = (MarketTenor)obj;
        return this.code.equals(other.code);
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    @ToString
    public String toString() {
        return this.code;
    }
}

