/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.PeriodAdditionConvention;
import com.opengamma.strata.basics.date.PeriodAdditionConventions;
import com.opengamma.strata.basics.date.Tenor;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class TenorAdjustment
implements Resolvable<DateAdjuster>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Tenor tenor;
    @PropertyDefinition(validate="notNull")
    private final PeriodAdditionConvention additionConvention;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment adjustment;
    private static final long serialVersionUID = 1L;

    public static TenorAdjustment of(Tenor tenor, PeriodAdditionConvention additionConvention, BusinessDayAdjustment adjustment) {
        return new TenorAdjustment(tenor, additionConvention, adjustment);
    }

    public static TenorAdjustment ofLastDay(Tenor tenor, BusinessDayAdjustment adjustment) {
        return new TenorAdjustment(tenor, PeriodAdditionConventions.LAST_DAY, adjustment);
    }

    public static TenorAdjustment ofLastBusinessDay(Tenor tenor, BusinessDayAdjustment adjustment) {
        return new TenorAdjustment(tenor, PeriodAdditionConventions.LAST_BUSINESS_DAY, adjustment);
    }

    @ImmutableValidator
    private void validate() {
        if (this.additionConvention.isMonthBased() && !this.tenor.isMonthBased()) {
            throw new IllegalArgumentException("Tenor must not contain days when addition convention is month-based");
        }
    }

    public LocalDate adjust(LocalDate date, ReferenceData refData) {
        HolidayCalendar holCal = this.adjustment.getCalendar().resolve(refData);
        BusinessDayConvention bda = this.adjustment.getConvention();
        return bda.adjust(this.additionConvention.adjust(date, this.tenor.getPeriod(), holCal), holCal);
    }

    @Override
    public DateAdjuster resolve(ReferenceData refData) {
        HolidayCalendar holCal = this.adjustment.getCalendar().resolve(refData);
        BusinessDayConvention bda = this.adjustment.getConvention();
        Period period = this.tenor.getPeriod();
        return date -> bda.adjust(this.additionConvention.adjust(date, period, holCal), holCal);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(this.tenor);
        if (this.additionConvention != PeriodAdditionConventions.NONE) {
            buf.append(" with ").append(this.additionConvention);
        }
        if (!this.adjustment.equals(BusinessDayAdjustment.NONE)) {
            buf.append(" then apply ").append(this.adjustment);
        }
        return buf.toString();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private TenorAdjustment(Tenor tenor, PeriodAdditionConvention additionConvention, BusinessDayAdjustment adjustment) {
        JodaBeanUtils.notNull((Object)tenor, (String)"tenor");
        JodaBeanUtils.notNull((Object)additionConvention, (String)"additionConvention");
        JodaBeanUtils.notNull((Object)adjustment, (String)"adjustment");
        this.tenor = tenor;
        this.additionConvention = additionConvention;
        this.adjustment = adjustment;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Tenor getTenor() {
        return this.tenor;
    }

    public PeriodAdditionConvention getAdditionConvention() {
        return this.additionConvention;
    }

    public BusinessDayAdjustment getAdjustment() {
        return this.adjustment;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TenorAdjustment other = (TenorAdjustment)obj;
            return JodaBeanUtils.equal((Object)this.tenor, (Object)other.tenor) && JodaBeanUtils.equal((Object)this.additionConvention, (Object)other.additionConvention) && JodaBeanUtils.equal((Object)this.adjustment, (Object)other.adjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.tenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.additionConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.adjustment);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<TenorAdjustment> {
        private Tenor tenor;
        private PeriodAdditionConvention additionConvention;
        private BusinessDayAdjustment adjustment;

        private Builder() {
        }

        private Builder(TenorAdjustment beanToCopy) {
            this.tenor = beanToCopy.getTenor();
            this.additionConvention = beanToCopy.getAdditionConvention();
            this.adjustment = beanToCopy.getAdjustment();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 110246592: {
                    return this.tenor;
                }
                case 1652975501: {
                    return this.additionConvention;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 110246592: {
                    this.tenor = (Tenor)newValue;
                    break;
                }
                case 1652975501: {
                    this.additionConvention = (PeriodAdditionConvention)newValue;
                    break;
                }
                case 1977085293: {
                    this.adjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public TenorAdjustment build() {
            return new TenorAdjustment(this.tenor, this.additionConvention, this.adjustment);
        }

        public Builder tenor(Tenor tenor) {
            JodaBeanUtils.notNull((Object)tenor, (String)"tenor");
            this.tenor = tenor;
            return this;
        }

        public Builder additionConvention(PeriodAdditionConvention additionConvention) {
            JodaBeanUtils.notNull((Object)additionConvention, (String)"additionConvention");
            this.additionConvention = additionConvention;
            return this;
        }

        public Builder adjustment(BusinessDayAdjustment adjustment) {
            JodaBeanUtils.notNull((Object)adjustment, (String)"adjustment");
            this.adjustment = adjustment;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("TenorAdjustment.Builder{");
            buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
            buf.append("additionConvention").append('=').append(JodaBeanUtils.toString((Object)this.additionConvention)).append(',').append(' ');
            buf.append("adjustment").append('=').append(JodaBeanUtils.toString((Object)this.adjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Tenor> tenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tenor", TenorAdjustment.class, Tenor.class);
        private final MetaProperty<PeriodAdditionConvention> additionConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"additionConvention", TenorAdjustment.class, PeriodAdditionConvention.class);
        private final MetaProperty<BusinessDayAdjustment> adjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"adjustment", TenorAdjustment.class, BusinessDayAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"tenor", "additionConvention", "adjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 110246592: {
                    return this.tenor;
                }
                case 1652975501: {
                    return this.additionConvention;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends TenorAdjustment> beanType() {
            return TenorAdjustment.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Tenor> tenor() {
            return this.tenor;
        }

        public MetaProperty<PeriodAdditionConvention> additionConvention() {
            return this.additionConvention;
        }

        public MetaProperty<BusinessDayAdjustment> adjustment() {
            return this.adjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 110246592: {
                    return ((TenorAdjustment)bean).getTenor();
                }
                case 1652975501: {
                    return ((TenorAdjustment)bean).getAdditionConvention();
                }
                case 1977085293: {
                    return ((TenorAdjustment)bean).getAdjustment();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

