/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.FloatingRateName;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.Named;
import java.util.Optional;

public interface FloatingRate
extends Named {
    public static FloatingRate parse(String indexStr) {
        ArgChecker.notNull((Object)indexStr, (String)"indexStr");
        return FloatingRate.tryParse(indexStr).orElseThrow(() -> new IllegalArgumentException("Floating rate index not known: " + indexStr));
    }

    public static Optional<FloatingRate> tryParse(String indexStr) {
        Optional iborOpt = IborIndex.extendedEnum().find(indexStr);
        if (iborOpt.isPresent()) {
            return iborOpt.map(t -> t);
        }
        Optional overnightOpt = OvernightIndex.extendedEnum().find(indexStr);
        if (overnightOpt.isPresent()) {
            return overnightOpt.map(t -> t);
        }
        Optional priceOpt = PriceIndex.extendedEnum().find(indexStr);
        if (priceOpt.isPresent()) {
            return priceOpt.map(t -> t);
        }
        Optional frnOpt = FloatingRateName.extendedEnum().find(indexStr);
        if (frnOpt.isPresent()) {
            return frnOpt.map(t -> t);
        }
        return Optional.empty();
    }

    public Currency getCurrency();

    public FloatingRateName getFloatingRateName();
}

