/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.basics.index.FxIndices;
import com.opengamma.strata.basics.index.ImmutableFxIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface FxIndex
extends Index,
Named {
    @FromString
    public static FxIndex of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        Optional fxIndexOpt = FxIndex.extendedEnum().find(uniqueName);
        if (fxIndexOpt.isPresent()) {
            return (FxIndex)fxIndexOpt.get();
        }
        try {
            CurrencyPair currencyPair = CurrencyPair.parse(uniqueName);
            return FxIndex.of(currencyPair);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unable to create FX index from " + uniqueName);
        }
    }

    public static FxIndex of(CurrencyPair currencyPair) {
        ArgChecker.notNull((Object)currencyPair, (String)"currencyPair");
        return FxIndex.extendedEnum().lookupAll().values().stream().filter(index -> index.getCurrencyPair().equals(currencyPair)).min(Comparator.comparing(FxIndex::getName)).orElseGet(() -> FxIndex.createFxIndex(currencyPair));
    }

    public static FxIndex createFxIndex(CurrencyPair currencyPair) {
        HolidayCalendarId calendarId = HolidayCalendarId.defaultByCurrencyPair(currencyPair);
        return ImmutableFxIndex.builder().name(currencyPair.toString()).currencyPair(currencyPair).fixingCalendar(calendarId).maturityDateOffset(DaysAdjustment.ofBusinessDays(2, calendarId)).build();
    }

    public static ExtendedEnum<FxIndex> extendedEnum() {
        return FxIndices.ENUM_LOOKUP;
    }

    public CurrencyPair getCurrencyPair();

    public DaysAdjustment getFixingDateOffset();

    public DaysAdjustment getMaturityDateOffset();

    public HolidayCalendarId getFixingCalendar();

    public LocalDate calculateMaturityFromFixing(LocalDate var1, ReferenceData var2);

    public LocalDate calculateFixingFromMaturity(LocalDate var1, ReferenceData var2);

    public Function<LocalDate, FxIndexObservation> resolve(ReferenceData var1);

    @Override
    @ToString
    public String getName();
}

