/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.TenorAdjustment;
import com.opengamma.strata.basics.index.IborIndexObservation;
import com.opengamma.strata.basics.index.IborIndices;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.function.Function;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface IborIndex
extends RateIndex,
Named {
    @FromString
    public static IborIndex of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (IborIndex)IborIndex.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<IborIndex> extendedEnum() {
        return IborIndices.ENUM_LOOKUP;
    }

    public DaysAdjustment getFixingDateOffset();

    public DaysAdjustment getEffectiveDateOffset();

    public TenorAdjustment getMaturityDateOffset();

    public ZonedDateTime calculateFixingDateTime(LocalDate var1);

    public LocalDate calculateEffectiveFromFixing(LocalDate var1, ReferenceData var2);

    public LocalDate calculateMaturityFromFixing(LocalDate var1, ReferenceData var2);

    public LocalDate calculateFixingFromEffective(LocalDate var1, ReferenceData var2);

    public LocalDate calculateMaturityFromEffective(LocalDate var1, ReferenceData var2);

    public Function<LocalDate, IborIndexObservation> resolve(ReferenceData var1);

    @Override
    @ToString
    public String getName();
}

