/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.location;

import com.google.common.base.CharMatcher;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharSource;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.io.PropertiesFile;
import com.opengamma.strata.collect.io.ResourceLocator;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class Country
implements Comparable<Country>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Supplier<ImmutableBiMap<String, String>> COUNTRY_CODES = Suppliers.memoize(() -> ImmutableBiMap.copyOf((Map)PropertiesFile.of((CharSource)ResourceLocator.ofClasspath(Country.class, (String)"country.properties").getCharSource()).getProperties().asMap()));
    private static final ConcurrentMap<String, Country> CACHE = new ConcurrentHashMap<String, Country>();
    private static final CharMatcher CODE_MATCHER = CharMatcher.inRange((char)'A', (char)'Z');
    public static final Country EU = Country.of("EU");
    public static final Country AT = Country.of("AT");
    public static final Country BE = Country.of("BE");
    public static final Country CH = Country.of("CH");
    public static final Country CZ = Country.of("CZ");
    public static final Country DE = Country.of("DE");
    public static final Country DK = Country.of("DK");
    public static final Country ES = Country.of("ES");
    public static final Country FI = Country.of("FI");
    public static final Country FR = Country.of("FR");
    public static final Country GB = Country.of("GB");
    public static final Country GR = Country.of("GR");
    public static final Country HU = Country.of("HU");
    public static final Country IE = Country.of("IE");
    public static final Country IS = Country.of("IS");
    public static final Country IT = Country.of("IT");
    public static final Country LU = Country.of("LU");
    public static final Country NL = Country.of("NL");
    public static final Country NO = Country.of("NO");
    public static final Country PL = Country.of("PL");
    public static final Country PT = Country.of("PT");
    public static final Country SE = Country.of("SE");
    public static final Country SK = Country.of("SK");
    public static final Country TR = Country.of("TR");
    public static final Country AR = Country.of("AR");
    public static final Country BR = Country.of("BR");
    public static final Country CA = Country.of("CA");
    public static final Country CL = Country.of("CL");
    public static final Country MX = Country.of("MX");
    public static final Country US = Country.of("US");
    public static final Country AU = Country.of("AU");
    public static final Country CN = Country.of("CN");
    public static final Country EG = Country.of("EG");
    public static final Country HK = Country.of("HK");
    public static final Country ID = Country.of("ID");
    public static final Country IL = Country.of("IL");
    public static final Country IN = Country.of("IN");
    public static final Country JP = Country.of("JP");
    public static final Country KR = Country.of("KR");
    public static final Country MY = Country.of("MY");
    public static final Country NZ = Country.of("NZ");
    public static final Country RU = Country.of("RU");
    public static final Country SA = Country.of("SA");
    public static final Country SG = Country.of("SG");
    public static final Country TH = Country.of("TH");
    public static final Country ZA = Country.of("ZA");
    private final String code;

    public static Set<Country> getAvailableCountries() {
        return ImmutableSet.copyOf(CACHE.values());
    }

    @FromString
    public static Country of(String countryCode) {
        ArgChecker.notNull((Object)countryCode, (String)"countryCode");
        return CACHE.computeIfAbsent(countryCode, c -> Country.addCode(c));
    }

    private static Country addCode(String countryCode) {
        ArgChecker.matches((CharMatcher)CODE_MATCHER, (int)2, (int)2, (String)countryCode, (String)"countryCode", (String)"[A-Z][A-Z]");
        return new Country(countryCode);
    }

    public static Country parse(String countryCode) {
        ArgChecker.notNull((Object)countryCode, (String)"countryCode");
        return Country.of(countryCode.toUpperCase(Locale.ENGLISH));
    }

    public static Country of3Char(String countryCode) {
        ArgChecker.matches((CharMatcher)CODE_MATCHER, (int)3, (int)3, (String)countryCode, (String)"countryCode", (String)"[A-Z][A-Z]");
        return Optional.ofNullable(((ImmutableBiMap)COUNTRY_CODES.get()).get((Object)countryCode)).map(alpha2Code -> Country.of(alpha2Code.toUpperCase(Locale.ENGLISH))).orElseThrow(() -> new IllegalArgumentException("Unknown country code: " + countryCode));
    }

    private Country(String code) {
        this.code = code;
    }

    private Object readResolve() {
        return Country.of(this.code);
    }

    public String getCode() {
        return this.code;
    }

    public String getCode3Char() {
        if (((ImmutableBiMap)COUNTRY_CODES.get()).containsValue((Object)this.getCode())) {
            return (String)((ImmutableBiMap)COUNTRY_CODES.get()).inverse().get((Object)this.getCode());
        }
        throw new IllegalArgumentException("Unknown country: " + this.getCode());
    }

    @Override
    public int compareTo(Country other) {
        return this.code.compareTo(other.code);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Country other = (Country)obj;
        return this.code.equals(other.code);
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    @ToString
    public String toString() {
        return this.code;
    }
}

