/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.schedule;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class SchedulePeriod
implements ImmutableBean,
Comparable<SchedulePeriod>,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedStartDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedEndDate;
    private static final long serialVersionUID = 1L;

    public static SchedulePeriod of(LocalDate startDate, LocalDate endDate, LocalDate unadjustedStartDate, LocalDate unadjustedEndDate) {
        return new SchedulePeriod(startDate, endDate, unadjustedStartDate, unadjustedEndDate);
    }

    public static SchedulePeriod of(LocalDate startDate, LocalDate endDate) {
        return new SchedulePeriod(startDate, endDate, startDate, endDate);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.unadjustedStartDate, (Object)this.unadjustedEndDate, (String)"unadjustedStartDate", (String)"unadjustedEndDate");
        ArgChecker.inOrderNotEqual((Comparable)this.startDate, (Object)this.endDate, (String)"startDate", (String)"endDate");
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.unadjustedStartDate == null) {
            builder.unadjustedStartDate = builder.startDate;
        }
        if (builder.unadjustedEndDate == null) {
            builder.unadjustedEndDate = builder.endDate;
        }
    }

    public Period length() {
        return Period.between(this.startDate, this.endDate);
    }

    public int lengthInDays() {
        return Math.toIntExact(this.endDate.toEpochDay() - this.startDate.toEpochDay());
    }

    public double yearFraction(DayCount dayCount, Schedule schedule) {
        ArgChecker.notNull((Object)dayCount, (String)"dayCount");
        ArgChecker.notNull((Object)schedule, (String)"schedule");
        return dayCount.yearFraction(this.startDate, this.endDate, schedule);
    }

    public boolean isRegular(Frequency frequency, RollConvention rollConvention) {
        ArgChecker.notNull((Object)frequency, (String)"frequency");
        ArgChecker.notNull((Object)rollConvention, (String)"rollConvention");
        return rollConvention.next(this.unadjustedStartDate, frequency).equals(this.unadjustedEndDate) && rollConvention.previous(this.unadjustedEndDate, frequency).equals(this.unadjustedStartDate);
    }

    public boolean contains(LocalDate date) {
        ArgChecker.notNull((Object)date, (String)"date");
        return !date.isBefore(this.startDate) && date.isBefore(this.endDate);
    }

    public PeriodicSchedule subSchedule(Frequency frequency, RollConvention rollConvention, StubConvention stubConvention, BusinessDayAdjustment adjustment) {
        return PeriodicSchedule.builder().startDate(this.unadjustedStartDate).endDate(this.unadjustedEndDate).frequency(frequency).businessDayAdjustment(adjustment).rollConvention(rollConvention).stubConvention(stubConvention).build();
    }

    public SchedulePeriod toAdjusted(DateAdjuster adjuster) {
        LocalDate resultStart = adjuster.adjust(this.startDate);
        LocalDate resultEnd = adjuster.adjust(this.endDate);
        if (resultStart.equals(this.startDate) && resultEnd.equals(this.endDate)) {
            return this;
        }
        return SchedulePeriod.of(resultStart, resultEnd, this.unadjustedStartDate, this.unadjustedEndDate);
    }

    SchedulePeriod toAdjusted(DateAdjuster adjuster, int mergeType) {
        LocalDate resultStart = adjuster.adjust(this.startDate);
        LocalDate resultEnd = adjuster.adjust(this.endDate);
        if (mergeType == -1 && resultStart.equals(resultEnd)) {
            resultStart = this.startDate;
        } else if (mergeType == 1 && resultStart.equals(resultEnd)) {
            resultEnd = this.endDate;
        }
        if (resultStart.equals(this.startDate) && resultEnd.equals(this.endDate)) {
            return this;
        }
        return SchedulePeriod.of(resultStart, resultEnd, this.unadjustedStartDate, this.unadjustedEndDate);
    }

    public SchedulePeriod toUnadjusted() {
        if (this.unadjustedStartDate.equals(this.startDate) && this.unadjustedEndDate.equals(this.endDate)) {
            return this;
        }
        return SchedulePeriod.of(this.unadjustedStartDate, this.unadjustedEndDate);
    }

    @Override
    public int compareTo(SchedulePeriod other) {
        return ComparisonChain.start().compare((Comparable)this.unadjustedStartDate, (Comparable)other.unadjustedStartDate).compare((Comparable)this.unadjustedEndDate, (Comparable)other.unadjustedEndDate).result();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private SchedulePeriod(LocalDate startDate, LocalDate endDate, LocalDate unadjustedStartDate, LocalDate unadjustedEndDate) {
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
        JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
        this.startDate = startDate;
        this.endDate = endDate;
        this.unadjustedStartDate = unadjustedStartDate;
        this.unadjustedEndDate = unadjustedEndDate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public LocalDate getUnadjustedStartDate() {
        return this.unadjustedStartDate;
    }

    public LocalDate getUnadjustedEndDate() {
        return this.unadjustedEndDate;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SchedulePeriod other = (SchedulePeriod)obj;
            return JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.unadjustedStartDate, (Object)other.unadjustedStartDate) && JodaBeanUtils.equal((Object)this.unadjustedEndDate, (Object)other.unadjustedEndDate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedEndDate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("SchedulePeriod{");
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
        buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SchedulePeriod> {
        private LocalDate startDate;
        private LocalDate endDate;
        private LocalDate unadjustedStartDate;
        private LocalDate unadjustedEndDate;

        private Builder() {
        }

        private Builder(SchedulePeriod beanToCopy) {
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.unadjustedStartDate = beanToCopy.getUnadjustedStartDate();
            this.unadjustedEndDate = beanToCopy.getUnadjustedEndDate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 1457691881: {
                    this.unadjustedStartDate = (LocalDate)newValue;
                    break;
                }
                case 31758114: {
                    this.unadjustedEndDate = (LocalDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SchedulePeriod build() {
            SchedulePeriod.preBuild(this);
            return new SchedulePeriod(this.startDate, this.endDate, this.unadjustedStartDate, this.unadjustedEndDate);
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder unadjustedStartDate(LocalDate unadjustedStartDate) {
            JodaBeanUtils.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
            this.unadjustedStartDate = unadjustedStartDate;
            return this;
        }

        public Builder unadjustedEndDate(LocalDate unadjustedEndDate) {
            JodaBeanUtils.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
            this.unadjustedEndDate = unadjustedEndDate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("SchedulePeriod.Builder{");
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("unadjustedStartDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedStartDate)).append(',').append(' ');
            buf.append("unadjustedEndDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedEndDate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", SchedulePeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", SchedulePeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedStartDate", SchedulePeriod.class, LocalDate.class);
        private final MetaProperty<LocalDate> unadjustedEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjustedEndDate", SchedulePeriod.class, LocalDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"startDate", "endDate", "unadjustedStartDate", "unadjustedEndDate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 1457691881: {
                    return this.unadjustedStartDate;
                }
                case 31758114: {
                    return this.unadjustedEndDate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SchedulePeriod> beanType() {
            return SchedulePeriod.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<LocalDate> unadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        public MetaProperty<LocalDate> unadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return ((SchedulePeriod)bean).getStartDate();
                }
                case -1607727319: {
                    return ((SchedulePeriod)bean).getEndDate();
                }
                case 1457691881: {
                    return ((SchedulePeriod)bean).getUnadjustedStartDate();
                }
                case 31758114: {
                    return ((SchedulePeriod)bean).getUnadjustedEndDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

