/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.schedule;

import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.basics.schedule.ScheduleException;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum StubConvention implements NamedEnum
{
    NONE{

        @Override
        StubConvention toImplicit(PeriodicSchedule definition, boolean explicitInitialStub, boolean explicitFinalStub) {
            if (explicitInitialStub || explicitFinalStub) {
                throw new ScheduleException(definition, "Dates specify an explicit stub, but stub convention is 'None'", new Object[0]);
            }
            return NONE;
        }
    }
    ,
    SHORT_INITIAL{

        @Override
        StubConvention toImplicit(PeriodicSchedule definition, boolean explicitInitialStub, boolean explicitFinalStub) {
            if (explicitFinalStub) {
                throw new ScheduleException(definition, "Dates specify an explicit final stub, but stub convention is 'ShortInitial'", new Object[0]);
            }
            return explicitInitialStub ? NONE : SHORT_INITIAL;
        }
    }
    ,
    LONG_INITIAL{

        @Override
        StubConvention toImplicit(PeriodicSchedule definition, boolean explicitInitialStub, boolean explicitFinalStub) {
            if (explicitFinalStub) {
                throw new ScheduleException(definition, "Dates specify an explicit final stub, but stub convention is 'LongInitial'", new Object[0]);
            }
            return explicitInitialStub ? NONE : LONG_INITIAL;
        }

        @Override
        boolean isStubLong(LocalDate date1, LocalDate date2) {
            return true;
        }
    }
    ,
    SMART_INITIAL{

        @Override
        StubConvention toImplicit(PeriodicSchedule definition, boolean explicitInitialStub, boolean explicitFinalStub) {
            if (explicitFinalStub) {
                return explicitInitialStub ? BOTH : SMART_INITIAL;
            }
            return explicitInitialStub ? NONE : SMART_INITIAL;
        }

        @Override
        boolean isStubLong(LocalDate date1, LocalDate date2) {
            return date1.plusDays(7L).isAfter(date2);
        }
    }
    ,
    SHORT_FINAL{

        @Override
        StubConvention toImplicit(PeriodicSchedule definition, boolean explicitInitialStub, boolean explicitFinalStub) {
            if (explicitInitialStub) {
                throw new ScheduleException(definition, "Dates specify an explicit initial stub, but stub convention is 'ShortFinal'", new Object[0]);
            }
            return explicitFinalStub ? NONE : SHORT_FINAL;
        }
    }
    ,
    LONG_FINAL{

        @Override
        StubConvention toImplicit(PeriodicSchedule definition, boolean explicitInitialStub, boolean explicitFinalStub) {
            if (explicitInitialStub) {
                throw new ScheduleException(definition, "Dates specify an explicit initial stub, but stub convention is 'LongFinal'", new Object[0]);
            }
            return explicitFinalStub ? NONE : LONG_FINAL;
        }

        @Override
        boolean isStubLong(LocalDate date1, LocalDate date2) {
            return true;
        }
    }
    ,
    SMART_FINAL{

        @Override
        StubConvention toImplicit(PeriodicSchedule definition, boolean explicitInitialStub, boolean explicitFinalStub) {
            if (explicitInitialStub) {
                return explicitFinalStub ? BOTH : SMART_FINAL;
            }
            return explicitFinalStub ? NONE : SMART_FINAL;
        }

        @Override
        boolean isStubLong(LocalDate date1, LocalDate date2) {
            return date1.plusDays(7L).isAfter(date2);
        }
    }
    ,
    BOTH{

        @Override
        StubConvention toImplicit(PeriodicSchedule definition, boolean explicitInitialStub, boolean explicitFinalStub) {
            if (!(explicitInitialStub && explicitFinalStub)) {
                throw new ScheduleException(definition, "Stub convention is 'Both' but explicit dates not specified", new Object[0]);
            }
            return NONE;
        }
    };

    private static final EnumNames<StubConvention> NAMES;

    @FromString
    public static StubConvention of(String name) {
        return (StubConvention)NAMES.parse(name);
    }

    public RollConvention toRollConvention(LocalDate start, LocalDate end, Frequency frequency, boolean preferEndOfMonth) {
        ArgChecker.notNull((Object)start, (String)"start");
        ArgChecker.notNull((Object)end, (String)"end");
        ArgChecker.notNull((Object)frequency, (String)"frequency");
        if (this == NONE && frequency.isMonthBased() && start.getDayOfMonth() != end.getDayOfMonth() && start.getLong(ChronoField.PROLEPTIC_MONTH) != end.getLong(ChronoField.PROLEPTIC_MONTH) && (start.getDayOfMonth() == start.lengthOfMonth() || end.getDayOfMonth() == end.lengthOfMonth())) {
            return preferEndOfMonth ? RollConventions.EOM : RollConvention.ofDayOfMonth(Math.max(start.getDayOfMonth(), end.getDayOfMonth()));
        }
        if (this.isCalculateBackwards()) {
            return StubConvention.impliedRollConvention(end, start, frequency, preferEndOfMonth);
        }
        return StubConvention.impliedRollConvention(start, end, frequency, preferEndOfMonth);
    }

    private static RollConvention impliedRollConvention(LocalDate date, LocalDate otherDate, Frequency frequency, boolean preferEndOfMonth) {
        if (frequency.isMonthBased()) {
            if (preferEndOfMonth && date.getDayOfMonth() == date.lengthOfMonth()) {
                return RollConventions.EOM;
            }
            return RollConvention.ofDayOfMonth(date.getDayOfMonth());
        }
        if (frequency.isWeekBased()) {
            return RollConvention.ofDayOfWeek(date.getDayOfWeek());
        }
        return RollConventions.NONE;
    }

    abstract StubConvention toImplicit(PeriodicSchedule var1, boolean var2, boolean var3);

    boolean isStubLong(LocalDate date1, LocalDate date2) {
        return false;
    }

    public boolean isCalculateForwards() {
        return this == SHORT_FINAL || this == LONG_FINAL || this == SMART_FINAL || this == NONE;
    }

    public boolean isCalculateBackwards() {
        return this == SHORT_INITIAL || this == LONG_INITIAL || this == SMART_INITIAL;
    }

    public boolean isFinal() {
        return this == SHORT_FINAL || this == LONG_FINAL || this == SMART_FINAL;
    }

    public boolean isLong() {
        return this == LONG_INITIAL || this == LONG_FINAL;
    }

    public boolean isShort() {
        return this == SHORT_INITIAL || this == SHORT_FINAL;
    }

    public boolean isSmart() {
        return this == SMART_INITIAL || this == SMART_FINAL;
    }

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(StubConvention.class);
    }
}

