/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.value;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.value.ValueAdjustment;
import com.opengamma.strata.basics.value.ValueStep;
import com.opengamma.strata.basics.value.ValueStepSequence;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ValueSchedule
implements ImmutableBean,
Serializable {
    public static final ValueSchedule ALWAYS_0 = ValueSchedule.of(0.0);
    public static final ValueSchedule ALWAYS_1 = ValueSchedule.of(1.0);
    @PropertyDefinition
    private final double initialValue;
    @PropertyDefinition(validate="notNull")
    private final List<ValueStep> steps;
    @PropertyDefinition(get="optional")
    private final ValueStepSequence stepSequence;
    private static final long serialVersionUID = 1L;

    public static ValueSchedule of(double value) {
        return new ValueSchedule(value, (List<ValueStep>)ImmutableList.of(), null);
    }

    public static ValueSchedule of(double initialValue, ValueStep ... steps) {
        return new ValueSchedule(initialValue, (List<ValueStep>)ImmutableList.copyOf((Object[])steps), null);
    }

    public static ValueSchedule of(double initialValue, List<ValueStep> steps) {
        return new ValueSchedule(initialValue, (List<ValueStep>)ImmutableList.copyOf(steps), null);
    }

    public static ValueSchedule of(double initialValue, ValueStepSequence stepSequence) {
        return new ValueSchedule(initialValue, (List<ValueStep>)ImmutableList.of(), stepSequence);
    }

    public DoubleArray resolveValues(Schedule schedule) {
        return this.resolveValues((List<SchedulePeriod>)schedule.getPeriods(), schedule.getRollConvention());
    }

    private DoubleArray resolveValues(List<SchedulePeriod> periods, RollConvention rollConv) {
        if (this.steps.size() == 0 && this.stepSequence == null) {
            return DoubleArray.filled((int)periods.size(), (double)this.initialValue);
        }
        return this.resolveSteps(periods, rollConv);
    }

    private DoubleArray resolveSteps(List<SchedulePeriod> periods, RollConvention rollConv) {
        int size = periods.size();
        double[] result = new double[size];
        List<ValueStep> resolvedSteps = this.getStepSequence().map(seq -> seq.resolve(this.steps, rollConv)).orElse(this.steps);
        ValueAdjustment[] expandedSteps = new ValueAdjustment[size];
        ArrayList<ValueStep> invalidSteps = new ArrayList<ValueStep>();
        for (ValueStep step : resolvedSteps) {
            int index = step.findIndex(periods);
            if (index < 0) {
                invalidSteps.add(step);
                continue;
            }
            if (expandedSteps[index] != null && !expandedSteps[index].equals(step.getValue())) {
                throw new IllegalArgumentException(Messages.format((String)"Invalid ValueSchedule, two steps resolved to the same schedule period starting on {}, schedule defined as {}", (Object[])new Object[]{periods.get(index).getUnadjustedStartDate(), this}));
            }
            expandedSteps[index] = step.getValue();
        }
        double value = this.initialValue;
        for (int i = 0; i < size; ++i) {
            if (expandedSteps[i] != null) {
                value = expandedSteps[i].adjust(value);
            }
            result[i] = value;
        }
        for (ValueStep step : invalidSteps) {
            double baseValue = result[step.findPreviousIndex(periods)];
            double adjusted = step.getValue().adjust(baseValue);
            if (adjusted == baseValue) continue;
            throw new IllegalArgumentException("ValueStep date does not match a period boundary: " + step.getDate().get());
        }
        return DoubleArray.ofUnsafe((double[])result);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ValueSchedule(double initialValue, List<ValueStep> steps, ValueStepSequence stepSequence) {
        JodaBeanUtils.notNull(steps, (String)"steps");
        this.initialValue = initialValue;
        this.steps = ImmutableList.copyOf(steps);
        this.stepSequence = stepSequence;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public List<ValueStep> getSteps() {
        return this.steps;
    }

    public Optional<ValueStepSequence> getStepSequence() {
        return Optional.ofNullable(this.stepSequence);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ValueSchedule other = (ValueSchedule)obj;
            return JodaBeanUtils.equal((double)this.initialValue, (double)other.initialValue) && JodaBeanUtils.equal(this.steps, other.steps) && JodaBeanUtils.equal((Object)this.stepSequence, (Object)other.stepSequence);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.initialValue);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.steps);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.stepSequence);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ValueSchedule{");
        buf.append("initialValue").append('=').append(JodaBeanUtils.toString((Object)this.initialValue)).append(',').append(' ');
        buf.append("steps").append('=').append(JodaBeanUtils.toString(this.steps)).append(',').append(' ');
        buf.append("stepSequence").append('=').append(JodaBeanUtils.toString((Object)this.stepSequence));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ValueSchedule> {
        private double initialValue;
        private List<ValueStep> steps = ImmutableList.of();
        private ValueStepSequence stepSequence;

        private Builder() {
        }

        private Builder(ValueSchedule beanToCopy) {
            this.initialValue = beanToCopy.getInitialValue();
            this.steps = ImmutableList.copyOf(beanToCopy.getSteps());
            this.stepSequence = beanToCopy.stepSequence;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -418368371: {
                    return this.initialValue;
                }
                case 109761319: {
                    return this.steps;
                }
                case 2141410989: {
                    return this.stepSequence;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -418368371: {
                    this.initialValue = (Double)newValue;
                    break;
                }
                case 109761319: {
                    this.steps = (List)newValue;
                    break;
                }
                case 2141410989: {
                    this.stepSequence = (ValueStepSequence)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ValueSchedule build() {
            return new ValueSchedule(this.initialValue, this.steps, this.stepSequence);
        }

        public Builder initialValue(double initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public Builder steps(List<ValueStep> steps) {
            JodaBeanUtils.notNull(steps, (String)"steps");
            this.steps = steps;
            return this;
        }

        public Builder steps(ValueStep ... steps) {
            return this.steps((List<ValueStep>)ImmutableList.copyOf((Object[])steps));
        }

        public Builder stepSequence(ValueStepSequence stepSequence) {
            this.stepSequence = stepSequence;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ValueSchedule.Builder{");
            buf.append("initialValue").append('=').append(JodaBeanUtils.toString((Object)this.initialValue)).append(',').append(' ');
            buf.append("steps").append('=').append(JodaBeanUtils.toString(this.steps)).append(',').append(' ');
            buf.append("stepSequence").append('=').append(JodaBeanUtils.toString((Object)this.stepSequence));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Double> initialValue = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"initialValue", ValueSchedule.class, Double.TYPE);
        private final MetaProperty<List<ValueStep>> steps = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"steps", ValueSchedule.class, List.class);
        private final MetaProperty<ValueStepSequence> stepSequence = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stepSequence", ValueSchedule.class, ValueStepSequence.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"initialValue", "steps", "stepSequence"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -418368371: {
                    return this.initialValue;
                }
                case 109761319: {
                    return this.steps;
                }
                case 2141410989: {
                    return this.stepSequence;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ValueSchedule> beanType() {
            return ValueSchedule.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Double> initialValue() {
            return this.initialValue;
        }

        public MetaProperty<List<ValueStep>> steps() {
            return this.steps;
        }

        public MetaProperty<ValueStepSequence> stepSequence() {
            return this.stepSequence;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -418368371: {
                    return ((ValueSchedule)bean).getInitialValue();
                }
                case 109761319: {
                    return ((ValueSchedule)bean).getSteps();
                }
                case 2141410989: {
                    return ((ValueSchedule)bean).stepSequence;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

