/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.ReportingCurrency;
import com.opengamma.strata.calc.runner.CalculationFunctions;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.calc.runner.CalculationParameters;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CalculationRules
implements ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final CalculationFunctions functions;
    @PropertyDefinition(validate="notNull")
    private final ReportingCurrency reportingCurrency;
    @PropertyDefinition(validate="notNull")
    private final CalculationParameters parameters;

    public static CalculationRules of(CalculationFunctions functions, CalculationParameter ... parameters) {
        CalculationParameters params = CalculationParameters.of(parameters);
        return new CalculationRules(functions, ReportingCurrency.NATURAL, params);
    }

    public static CalculationRules of(CalculationFunctions functions, CalculationParameters parameters) {
        return new CalculationRules(functions, ReportingCurrency.NATURAL, parameters);
    }

    public static CalculationRules of(CalculationFunctions functions, Currency reportingCurrency, CalculationParameter ... parameters) {
        CalculationParameters params = CalculationParameters.of(parameters);
        return new CalculationRules(functions, ReportingCurrency.of(reportingCurrency), params);
    }

    public static CalculationRules of(CalculationFunctions functions, ReportingCurrency reportingCurrency, CalculationParameters parameters) {
        return new CalculationRules(functions, reportingCurrency, parameters);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.parameters = CalculationParameters.empty();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CalculationRules(CalculationFunctions functions, ReportingCurrency reportingCurrency, CalculationParameters parameters) {
        JodaBeanUtils.notNull((Object)functions, (String)"functions");
        JodaBeanUtils.notNull((Object)reportingCurrency, (String)"reportingCurrency");
        JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
        this.functions = functions;
        this.reportingCurrency = reportingCurrency;
        this.parameters = parameters;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CalculationFunctions getFunctions() {
        return this.functions;
    }

    public ReportingCurrency getReportingCurrency() {
        return this.reportingCurrency;
    }

    public CalculationParameters getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CalculationRules other = (CalculationRules)obj;
            return JodaBeanUtils.equal((Object)this.functions, (Object)other.functions) && JodaBeanUtils.equal((Object)this.reportingCurrency, (Object)other.reportingCurrency) && JodaBeanUtils.equal((Object)this.parameters, (Object)other.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.functions);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.reportingCurrency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.parameters);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("CalculationRules{");
        buf.append("functions").append('=').append(JodaBeanUtils.toString((Object)this.functions)).append(',').append(' ');
        buf.append("reportingCurrency").append('=').append(JodaBeanUtils.toString((Object)this.reportingCurrency)).append(',').append(' ');
        buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CalculationRules> {
        private CalculationFunctions functions;
        private ReportingCurrency reportingCurrency;
        private CalculationParameters parameters;

        private Builder() {
            CalculationRules.applyDefaults(this);
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -140572773: {
                    return this.functions;
                }
                case -1287844769: {
                    return this.reportingCurrency;
                }
                case 458736106: {
                    return this.parameters;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -140572773: {
                    this.functions = (CalculationFunctions)newValue;
                    break;
                }
                case -1287844769: {
                    this.reportingCurrency = (ReportingCurrency)newValue;
                    break;
                }
                case 458736106: {
                    this.parameters = (CalculationParameters)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CalculationRules build() {
            return new CalculationRules(this.functions, this.reportingCurrency, this.parameters);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("CalculationRules.Builder{");
            buf.append("functions").append('=').append(JodaBeanUtils.toString((Object)this.functions)).append(',').append(' ');
            buf.append("reportingCurrency").append('=').append(JodaBeanUtils.toString((Object)this.reportingCurrency)).append(',').append(' ');
            buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CalculationFunctions> functions = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"functions", CalculationRules.class, CalculationFunctions.class);
        private final MetaProperty<ReportingCurrency> reportingCurrency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"reportingCurrency", CalculationRules.class, ReportingCurrency.class);
        private final MetaProperty<CalculationParameters> parameters = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameters", CalculationRules.class, CalculationParameters.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"functions", "reportingCurrency", "parameters"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -140572773: {
                    return this.functions;
                }
                case -1287844769: {
                    return this.reportingCurrency;
                }
                case 458736106: {
                    return this.parameters;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CalculationRules> builder() {
            return new Builder();
        }

        public Class<? extends CalculationRules> beanType() {
            return CalculationRules.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CalculationFunctions> functions() {
            return this.functions;
        }

        public MetaProperty<ReportingCurrency> reportingCurrency() {
            return this.reportingCurrency;
        }

        public MetaProperty<CalculationParameters> parameters() {
            return this.parameters;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -140572773: {
                    return ((CalculationRules)bean).getFunctions();
                }
                case -1287844769: {
                    return ((CalculationRules)bean).getReportingCurrency();
                }
                case 458736106: {
                    return ((CalculationRules)bean).getParameters();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

