/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.ColumnHeader;
import com.opengamma.strata.calc.ColumnName;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.ReportingCurrency;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.calc.runner.CalculationParameters;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class Column
implements ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final ColumnName name;
    @PropertyDefinition(validate="notNull")
    private final Measure measure;
    @PropertyDefinition(get="optional")
    private final ReportingCurrency reportingCurrency;
    @PropertyDefinition
    private final CalculationParameters parameters;

    public static Column of(Measure measure) {
        ColumnName name = ColumnName.of(measure);
        return new Column(name, measure, null, CalculationParameters.empty());
    }

    public static Column of(Measure measure, Currency currency) {
        ColumnName name = ColumnName.of(measure);
        return new Column(name, measure, ReportingCurrency.of(currency), CalculationParameters.empty());
    }

    public static Column of(Measure measure, CalculationParameter ... parameters) {
        ColumnName name = ColumnName.of(measure);
        return new Column(name, measure, null, CalculationParameters.of(parameters));
    }

    public static Column of(Measure measure, Currency currency, CalculationParameter ... parameters) {
        ColumnName name = ColumnName.of(measure);
        return new Column(name, measure, ReportingCurrency.of(currency), CalculationParameters.of(parameters));
    }

    public static Column of(Measure measure, String columnName) {
        ColumnName name = ColumnName.of(columnName);
        return new Column(name, measure, null, CalculationParameters.empty());
    }

    public static Column of(Measure measure, String columnName, Currency currency) {
        ColumnName name = ColumnName.of(columnName);
        return new Column(name, measure, ReportingCurrency.of(currency), CalculationParameters.empty());
    }

    public static Column of(Measure measure, String columnName, CalculationParameter ... parameters) {
        ColumnName name = ColumnName.of(columnName);
        return new Column(name, measure, null, CalculationParameters.of(parameters));
    }

    public static Column of(Measure measure, String columnName, Currency currency, CalculationParameter ... parameters) {
        ColumnName name = ColumnName.of(columnName);
        return new Column(name, measure, ReportingCurrency.of(currency), CalculationParameters.of(parameters));
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.parameters(CalculationParameters.empty());
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.name == null && builder.measure != null) {
            builder.name(ColumnName.of(builder.measure.getName()));
        }
    }

    public Column combineWithDefaults(ReportingCurrency reportingCurrency, CalculationParameters defaultParameters) {
        CalculationParameters combinedParams = this.parameters.combinedWith(defaultParameters);
        return new Column(this.name, this.measure, this.getReportingCurrency().orElse(reportingCurrency), combinedParams);
    }

    public ColumnHeader toHeader() {
        ReportingCurrency reportingCurrency;
        if (this.measure.isCurrencyConvertible() && (reportingCurrency = this.getReportingCurrency().orElse(ReportingCurrency.NATURAL)).isSpecific()) {
            return ColumnHeader.of(this.name, this.measure, reportingCurrency.getCurrency());
        }
        return ColumnHeader.of(this.name, this.measure);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Column(ColumnName name, Measure measure, ReportingCurrency reportingCurrency, CalculationParameters parameters) {
        JodaBeanUtils.notNull((Object)((Object)name), (String)"name");
        JodaBeanUtils.notNull((Object)measure, (String)"measure");
        this.name = name;
        this.measure = measure;
        this.reportingCurrency = reportingCurrency;
        this.parameters = parameters;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ColumnName getName() {
        return this.name;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public Optional<ReportingCurrency> getReportingCurrency() {
        return Optional.ofNullable(this.reportingCurrency);
    }

    public CalculationParameters getParameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Column other = (Column)obj;
            return JodaBeanUtils.equal((Object)((Object)this.name), (Object)((Object)other.name)) && JodaBeanUtils.equal((Object)this.measure, (Object)other.measure) && JodaBeanUtils.equal((Object)this.reportingCurrency, (Object)other.reportingCurrency) && JodaBeanUtils.equal((Object)this.parameters, (Object)other.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.name));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.measure);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.reportingCurrency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.parameters);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("Column{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)((Object)this.name))).append(',').append(' ');
        buf.append("measure").append('=').append(JodaBeanUtils.toString((Object)this.measure)).append(',').append(' ');
        buf.append("reportingCurrency").append('=').append(JodaBeanUtils.toString((Object)this.reportingCurrency)).append(',').append(' ');
        buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<Column> {
        private ColumnName name;
        private Measure measure;
        private ReportingCurrency reportingCurrency;
        private CalculationParameters parameters;

        private Builder() {
            Column.applyDefaults(this);
        }

        private Builder(Column beanToCopy) {
            this.name = beanToCopy.getName();
            this.measure = beanToCopy.getMeasure();
            this.reportingCurrency = beanToCopy.reportingCurrency;
            this.parameters = beanToCopy.getParameters();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 938321246: {
                    return this.measure;
                }
                case -1287844769: {
                    return this.reportingCurrency;
                }
                case 458736106: {
                    return this.parameters;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (ColumnName)((Object)newValue);
                    break;
                }
                case 938321246: {
                    this.measure = (Measure)newValue;
                    break;
                }
                case -1287844769: {
                    this.reportingCurrency = (ReportingCurrency)newValue;
                    break;
                }
                case 458736106: {
                    this.parameters = (CalculationParameters)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public Column build() {
            Column.preBuild(this);
            return new Column(this.name, this.measure, this.reportingCurrency, this.parameters);
        }

        public Builder name(ColumnName name) {
            JodaBeanUtils.notNull((Object)((Object)name), (String)"name");
            this.name = name;
            return this;
        }

        public Builder measure(Measure measure) {
            JodaBeanUtils.notNull((Object)measure, (String)"measure");
            this.measure = measure;
            return this;
        }

        public Builder reportingCurrency(ReportingCurrency reportingCurrency) {
            this.reportingCurrency = reportingCurrency;
            return this;
        }

        public Builder parameters(CalculationParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("Column.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)((Object)this.name))).append(',').append(' ');
            buf.append("measure").append('=').append(JodaBeanUtils.toString((Object)this.measure)).append(',').append(' ');
            buf.append("reportingCurrency").append('=').append(JodaBeanUtils.toString((Object)this.reportingCurrency)).append(',').append(' ');
            buf.append("parameters").append('=').append(JodaBeanUtils.toString((Object)this.parameters));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ColumnName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", Column.class, ColumnName.class);
        private final MetaProperty<Measure> measure = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"measure", Column.class, Measure.class);
        private final MetaProperty<ReportingCurrency> reportingCurrency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"reportingCurrency", Column.class, ReportingCurrency.class);
        private final MetaProperty<CalculationParameters> parameters = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"parameters", Column.class, CalculationParameters.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "measure", "reportingCurrency", "parameters"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 938321246: {
                    return this.measure;
                }
                case -1287844769: {
                    return this.reportingCurrency;
                }
                case 458736106: {
                    return this.parameters;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends Column> beanType() {
            return Column.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ColumnName> name() {
            return this.name;
        }

        public MetaProperty<Measure> measure() {
            return this.measure;
        }

        public MetaProperty<ReportingCurrency> reportingCurrency() {
            return this.reportingCurrency;
        }

        public MetaProperty<CalculationParameters> parameters() {
            return this.parameters;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((Column)bean).getName();
                }
                case 938321246: {
                    return ((Column)bean).getMeasure();
                }
                case -1287844769: {
                    return ((Column)bean).reportingCurrency;
                }
                case 458736106: {
                    return ((Column)bean).getParameters();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

