/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.ColumnName;
import com.opengamma.strata.calc.Measure;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ColumnHeader
implements ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final ColumnName name;
    @PropertyDefinition(validate="notNull")
    private final Measure measure;
    @PropertyDefinition(get="optional")
    private final Currency currency;

    public static ColumnHeader of(ColumnName name, Measure measure) {
        return new ColumnHeader(name, measure, null);
    }

    public static ColumnHeader of(ColumnName name, Measure measure, Currency currency) {
        return new ColumnHeader(name, measure, currency);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ColumnHeader(ColumnName name, Measure measure, Currency currency) {
        JodaBeanUtils.notNull((Object)((Object)name), (String)"name");
        JodaBeanUtils.notNull((Object)measure, (String)"measure");
        this.name = name;
        this.measure = measure;
        this.currency = currency;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ColumnName getName() {
        return this.name;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public Optional<Currency> getCurrency() {
        return Optional.ofNullable(this.currency);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ColumnHeader other = (ColumnHeader)obj;
            return JodaBeanUtils.equal((Object)((Object)this.name), (Object)((Object)other.name)) && JodaBeanUtils.equal((Object)this.measure, (Object)other.measure) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.name));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.measure);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ColumnHeader{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)((Object)this.name))).append(',').append(' ');
        buf.append("measure").append('=').append(JodaBeanUtils.toString((Object)this.measure)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ColumnHeader> {
        private ColumnName name;
        private Measure measure;
        private Currency currency;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 938321246: {
                    return this.measure;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (ColumnName)((Object)newValue);
                    break;
                }
                case 938321246: {
                    this.measure = (Measure)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ColumnHeader build() {
            return new ColumnHeader(this.name, this.measure, this.currency);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ColumnHeader.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)((Object)this.name))).append(',').append(' ');
            buf.append("measure").append('=').append(JodaBeanUtils.toString((Object)this.measure)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ColumnName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ColumnHeader.class, ColumnName.class);
        private final MetaProperty<Measure> measure = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"measure", ColumnHeader.class, Measure.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ColumnHeader.class, Currency.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "measure", "currency"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 938321246: {
                    return this.measure;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ColumnHeader> builder() {
            return new Builder();
        }

        public Class<? extends ColumnHeader> beanType() {
            return ColumnHeader.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ColumnName> name() {
            return this.name;
        }

        public MetaProperty<Measure> measure() {
            return this.measure;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ColumnHeader)bean).getName();
                }
                case 938321246: {
                    return ((ColumnHeader)bean).getMeasure();
                }
                case 575402001: {
                    return ((ColumnHeader)bean).currency;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

