/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.calc.ColumnHeader;
import com.opengamma.strata.calc.ColumnName;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioArray;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class Results
implements ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<ColumnHeader> columns;
    @PropertyDefinition(validate="notNull", builderType="List<? extends Result<?>>")
    private final ImmutableList<Result<?>> cells;
    private final transient int rowCount;
    private final transient int columnCount;

    public static Results of(List<ColumnHeader> columns, List<? extends Result<?>> cells) {
        return new Results(columns, cells);
    }

    @ImmutableConstructor
    private Results(List<ColumnHeader> columns, List<? extends Result<?>> cells) {
        JodaBeanUtils.notNull(columns, (String)"columns");
        JodaBeanUtils.notNull(cells, (String)"cells");
        this.columns = ImmutableList.copyOf(columns);
        this.cells = ImmutableList.copyOf(cells);
        this.columnCount = columns.size();
        int n = this.rowCount = this.columnCount == 0 ? 0 : cells.size() / this.columnCount;
        if (this.rowCount * this.columnCount != cells.size()) {
            throw new IllegalArgumentException(Messages.format((String)"The number of cells ({}) must equal the number of rows ({}) multiplied by the number of columns ({})", (Object[])new Object[]{this.cells.size(), this.rowCount, this.columnCount}));
        }
    }

    private Object readResolve() {
        return new Results((List<ColumnHeader>)this.columns, (List<? extends Result<?>>)this.cells);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Result<?> get(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.rowCount) {
            throw new IllegalArgumentException(this.invalidRowIndexMessage(rowIndex));
        }
        if (columnIndex < 0 || columnIndex >= this.columnCount) {
            throw new IllegalArgumentException(this.invalidColumnIndexMessage(columnIndex));
        }
        return this.get0(rowIndex, columnIndex);
    }

    private Result<?> get0(int rowIndex, int columnIndex) {
        int index = rowIndex * this.columnCount + columnIndex;
        return (Result)this.cells.get(index);
    }

    private String invalidRowIndexMessage(int rowIndex) {
        return Messages.format((String)"Row index must be greater than or equal to zero and less than the row count ({}), but it was {}", (Object[])new Object[]{this.rowCount, rowIndex});
    }

    private String invalidColumnIndexMessage(int columnIndex) {
        return Messages.format((String)"Column index must be greater than or equal to zero and less than the column count ({}), but it was {}", (Object[])new Object[]{this.columnCount, columnIndex});
    }

    public <T> Result<T> get(int rowIndex, int columnIndex, Class<T> type) {
        return Results.cast(this.get(rowIndex, columnIndex), type);
    }

    public Result<?> get(int rowIndex, ColumnName columnName) {
        return this.get(rowIndex, this.columnIndexByName(columnName));
    }

    public int columnIndexByName(ColumnName columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!((ColumnHeader)this.columns.get(i)).getName().equals((Object)columnName)) continue;
            return i;
        }
        throw new IllegalArgumentException(this.invalidColumnNameMessage(columnName));
    }

    private String invalidColumnNameMessage(ColumnName columnName) {
        return Messages.format((String)"Column name not found: {}", (Object)((Object)columnName));
    }

    public <T> Result<T> get(int rowIndex, ColumnName columnName, Class<T> type) {
        return Results.cast(this.get(rowIndex, columnName), type);
    }

    public <C> Result<ScenarioArray<C>> getScenarios(int rowIndex, int columnIndex, Class<C> componentType) {
        return Results.castScenario(this.get(rowIndex, columnIndex), componentType);
    }

    public <C> Result<ScenarioArray<C>> getScenarios(int rowIndex, ColumnName columnName, Class<C> componentType) {
        return Results.castScenario(this.get(rowIndex, columnName), componentType);
    }

    public <T> Stream<Result<?>> columnResults(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnCount) {
            throw new IllegalArgumentException(this.invalidColumnIndexMessage(columnIndex));
        }
        ResultSpliterator spliterator = new ResultSpliterator(this, columnIndex, 0, this.rowCount);
        return StreamSupport.stream(spliterator, false);
    }

    public <T> Stream<Result<T>> columnResults(int columnIndex, Class<T> type) {
        return this.columnResults(columnIndex).map(result -> Results.cast(result, type));
    }

    public <C> Stream<Result<ScenarioArray<C>>> columnResultsScenarios(int columnIndex, Class<C> componentType) {
        return this.columnResults(columnIndex).map(result -> Results.castScenario(result, componentType));
    }

    private static <T> Result<T> cast(Result<?> result, Class<T> type) {
        if (result.isFailure() || type.isInstance(result.getValue())) {
            return result;
        }
        throw new ClassCastException(Messages.format((String)"Result queried with type '{}' but was '{}'", (Object[])new Object[]{type.getName(), result.getValue().getClass().getName()}));
    }

    private static <C> Result<ScenarioArray<C>> castScenario(Result<?> result, Class<C> componentType) {
        if (result.isFailure()) {
            return result;
        }
        if (ScenarioArray.class.isInstance(result.getValue())) {
            ScenarioArray array = (ScenarioArray)result.getValue();
            if (array.getScenarioCount() > 0 && !componentType.isInstance(array.get(0))) {
                throw new ClassCastException(Messages.format((String)"Result queried with component type '{}' but was '{}'", (Object[])new Object[]{componentType.getName(), array.get(0).getClass().getName()}));
            }
            return result;
        }
        throw new ClassCastException(Messages.format((String)"Result queried with type 'ScenarioArray' but was '{}'", (Object)result.getValue().getClass().getName()));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<ColumnHeader> getColumns() {
        return this.columns;
    }

    public ImmutableList<Result<?>> getCells() {
        return this.cells;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Results other = (Results)obj;
            return JodaBeanUtils.equal(this.columns, other.columns) && JodaBeanUtils.equal(this.cells, other.cells);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.columns);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.cells);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("Results{");
        buf.append("columns").append('=').append(JodaBeanUtils.toString(this.columns)).append(',').append(' ');
        buf.append("cells").append('=').append(JodaBeanUtils.toString(this.cells));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<Results> {
        private List<ColumnHeader> columns = ImmutableList.of();
        private List<? extends Result<?>> cells = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 949721053: {
                    return this.columns;
                }
                case 94544721: {
                    return this.cells;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 949721053: {
                    this.columns = (List)newValue;
                    break;
                }
                case 94544721: {
                    this.cells = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Results build() {
            return new Results(this.columns, this.cells);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("Results.Builder{");
            buf.append("columns").append('=').append(JodaBeanUtils.toString(this.columns)).append(',').append(' ');
            buf.append("cells").append('=').append(JodaBeanUtils.toString(this.cells));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<ColumnHeader>> columns = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"columns", Results.class, ImmutableList.class);
        private final MetaProperty<ImmutableList<Result<?>>> cells = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"cells", Results.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"columns", "cells"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 949721053: {
                    return this.columns;
                }
                case 94544721: {
                    return this.cells;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends Results> builder() {
            return new Builder();
        }

        public Class<? extends Results> beanType() {
            return Results.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<ColumnHeader>> columns() {
            return this.columns;
        }

        public MetaProperty<ImmutableList<Result<?>>> cells() {
            return this.cells;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 949721053: {
                    return ((Results)bean).getColumns();
                }
                case 94544721: {
                    return ((Results)bean).getCells();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }

    private static class ResultSpliterator
    implements Spliterator<Result<?>> {
        private final Results results;
        private final int columnIndex;
        private final int endRowExclusive;
        private int currentRow;

        private ResultSpliterator(Results results, int columnIndex, int startRow, int endRowExclusive) {
            this.results = results;
            this.columnIndex = columnIndex;
            this.endRowExclusive = endRowExclusive;
            this.currentRow = startRow;
        }

        @Override
        public void forEachRemaining(Consumer<? super Result<?>> action) {
            while (this.currentRow < this.endRowExclusive) {
                action.accept(this.results.get0(this.currentRow, this.columnIndex));
                ++this.currentRow;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Result<?>> action) {
            if (this.currentRow < this.endRowExclusive) {
                action.accept(this.results.get0(this.currentRow, this.columnIndex));
                ++this.currentRow;
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<Result<?>> trySplit() {
            int lo = this.currentRow;
            int mid = (lo + this.endRowExclusive) / 2;
            if (lo >= mid) {
                return null;
            }
            this.currentRow = mid;
            return new ResultSpliterator(this.results, this.columnIndex, lo, mid);
        }

        @Override
        public long estimateSize() {
            return this.endRowExclusive - this.currentRow;
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.estimateSize();
        }

        @Override
        public int characteristics() {
            return 17744;
        }
    }
}

