/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.calc.marketdata.BuiltScenarioMarketDataBuilder;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.Failure;
import com.opengamma.strata.collect.result.FailureException;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.FxRateId;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.ImmutableScenarioMarketData;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class BuiltScenarioMarketData
implements ScenarioMarketData,
ImmutableBean {
    private static final BuiltScenarioMarketData EMPTY = new BuiltScenarioMarketData(ImmutableScenarioMarketData.empty(), (Map<? extends MarketDataId<?>, Failure>)ImmutableMap.of(), (Map<? extends MarketDataId<?>, Failure>)ImmutableMap.of());
    @PropertyDefinition(validate="notNull")
    private final ImmutableScenarioMarketData underlying;
    @PropertyDefinition(validate="notNull", builderType="Map<? extends MarketDataId<?>, Failure>")
    private final ImmutableMap<MarketDataId<?>, Failure> valueFailures;
    @PropertyDefinition(validate="notNull", builderType="Map<? extends MarketDataId<?>, Failure>")
    private final ImmutableMap<MarketDataId<?>, Failure> timeSeriesFailures;

    static BuiltScenarioMarketDataBuilder builder(LocalDate valuationDate) {
        return new BuiltScenarioMarketDataBuilder(valuationDate);
    }

    static BuiltScenarioMarketDataBuilder builder(MarketDataBox<LocalDate> valuationDate) {
        return new BuiltScenarioMarketDataBuilder(valuationDate);
    }

    static BuiltScenarioMarketData empty() {
        return EMPTY;
    }

    public MarketDataBox<LocalDate> getValuationDate() {
        return this.underlying.getValuationDate();
    }

    public int getScenarioCount() {
        return this.underlying.getScenarioCount();
    }

    public boolean containsValue(MarketDataId<?> id) {
        return this.underlying.containsValue(id);
    }

    public <T> MarketDataBox<T> getValue(MarketDataId<T> id) {
        if (id instanceof FxRateId && ((FxRateId)id).getPair().isIdentity()) {
            FxRateId fxRateId = (FxRateId)id;
            FxRate identityRate = FxRate.of((CurrencyPair)fxRateId.getPair(), (double)1.0);
            return MarketDataBox.ofSingleValue((Object)identityRate);
        }
        Optional opt = this.underlying.findValue(id);
        if (!opt.isPresent()) {
            Failure failure = (Failure)this.valueFailures.get(id);
            if (failure != null) {
                throw new FailureException(failure);
            }
            throw new MarketDataNotFoundException(Messages.format((String)"Market data not found for identifier '{}' of type '{}'", (Object[])new Object[]{id, id.getClass().getSimpleName()}));
        }
        return (MarketDataBox)opt.get();
    }

    public <T> Optional<MarketDataBox<T>> findValue(MarketDataId<T> id) {
        return this.underlying.findValue(id);
    }

    public Set<MarketDataId<?>> getIds() {
        return this.underlying.getIds();
    }

    public <T> Set<MarketDataId<T>> findIds(MarketDataName<T> name) {
        return this.underlying.findIds(name);
    }

    public Set<ObservableId> getTimeSeriesIds() {
        return this.underlying.getTimeSeriesIds();
    }

    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId id) {
        return this.underlying.getTimeSeries(id);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    BuiltScenarioMarketData(ImmutableScenarioMarketData underlying, Map<? extends MarketDataId<?>, Failure> valueFailures, Map<? extends MarketDataId<?>, Failure> timeSeriesFailures) {
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        JodaBeanUtils.notNull(valueFailures, (String)"valueFailures");
        JodaBeanUtils.notNull(timeSeriesFailures, (String)"timeSeriesFailures");
        this.underlying = underlying;
        this.valueFailures = ImmutableMap.copyOf(valueFailures);
        this.timeSeriesFailures = ImmutableMap.copyOf(timeSeriesFailures);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableScenarioMarketData getUnderlying() {
        return this.underlying;
    }

    public ImmutableMap<MarketDataId<?>, Failure> getValueFailures() {
        return this.valueFailures;
    }

    public ImmutableMap<MarketDataId<?>, Failure> getTimeSeriesFailures() {
        return this.timeSeriesFailures;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BuiltScenarioMarketData other = (BuiltScenarioMarketData)obj;
            return JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying) && JodaBeanUtils.equal(this.valueFailures, other.valueFailures) && JodaBeanUtils.equal(this.timeSeriesFailures, other.timeSeriesFailures);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.valueFailures);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.timeSeriesFailures);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("BuiltScenarioMarketData{");
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying)).append(',').append(' ');
        buf.append("valueFailures").append('=').append(JodaBeanUtils.toString(this.valueFailures)).append(',').append(' ');
        buf.append("timeSeriesFailures").append('=').append(JodaBeanUtils.toString(this.timeSeriesFailures));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<BuiltScenarioMarketData> {
        private ImmutableScenarioMarketData underlying;
        private Map<? extends MarketDataId<?>, Failure> valueFailures = ImmutableMap.of();
        private Map<? extends MarketDataId<?>, Failure> timeSeriesFailures = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    return this.underlying;
                }
                case -68881222: {
                    return this.valueFailures;
                }
                case -1580093459: {
                    return this.timeSeriesFailures;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    this.underlying = (ImmutableScenarioMarketData)newValue;
                    break;
                }
                case -68881222: {
                    this.valueFailures = (Map)newValue;
                    break;
                }
                case -1580093459: {
                    this.timeSeriesFailures = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public BuiltScenarioMarketData build() {
            return new BuiltScenarioMarketData(this.underlying, this.valueFailures, this.timeSeriesFailures);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("BuiltScenarioMarketData.Builder{");
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying)).append(',').append(' ');
            buf.append("valueFailures").append('=').append(JodaBeanUtils.toString(this.valueFailures)).append(',').append(' ');
            buf.append("timeSeriesFailures").append('=').append(JodaBeanUtils.toString(this.timeSeriesFailures));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableScenarioMarketData> underlying = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlying", BuiltScenarioMarketData.class, ImmutableScenarioMarketData.class);
        private final MetaProperty<ImmutableMap<MarketDataId<?>, Failure>> valueFailures = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valueFailures", BuiltScenarioMarketData.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<MarketDataId<?>, Failure>> timeSeriesFailures = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeSeriesFailures", BuiltScenarioMarketData.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"underlying", "valueFailures", "timeSeriesFailures"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    return this.underlying;
                }
                case -68881222: {
                    return this.valueFailures;
                }
                case -1580093459: {
                    return this.timeSeriesFailures;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends BuiltScenarioMarketData> builder() {
            return new Builder();
        }

        public Class<? extends BuiltScenarioMarketData> beanType() {
            return BuiltScenarioMarketData.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableScenarioMarketData> underlying() {
            return this.underlying;
        }

        public MetaProperty<ImmutableMap<MarketDataId<?>, Failure>> valueFailures() {
            return this.valueFailures;
        }

        public MetaProperty<ImmutableMap<MarketDataId<?>, Failure>> timeSeriesFailures() {
            return this.timeSeriesFailures;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1770633379: {
                    return ((BuiltScenarioMarketData)bean).getUnderlying();
                }
                case -68881222: {
                    return ((BuiltScenarioMarketData)bean).getValueFailures();
                }
                case -1580093459: {
                    return ((BuiltScenarioMarketData)bean).getTimeSeriesFailures();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

