/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.calc.marketdata.BuiltMarketData;
import com.opengamma.strata.calc.marketdata.BuiltScenarioMarketData;
import com.opengamma.strata.calc.marketdata.BuiltScenarioMarketDataBuilder;
import com.opengamma.strata.calc.marketdata.MarketDataConfig;
import com.opengamma.strata.calc.marketdata.MarketDataFactory;
import com.opengamma.strata.calc.marketdata.MarketDataFunction;
import com.opengamma.strata.calc.marketdata.MarketDataNode;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.calc.marketdata.ObservableDataProvider;
import com.opengamma.strata.calc.marketdata.PerturbationMapping;
import com.opengamma.strata.calc.marketdata.ScenarioDefinition;
import com.opengamma.strata.calc.marketdata.TimeSeriesProvider;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class DefaultMarketDataFactory
implements MarketDataFactory {
    private final ObservableDataProvider observableDataProvider;
    private final TimeSeriesProvider timeSeriesProvider;
    private final Map<Class<? extends MarketDataId<?>>, MarketDataFunction<?, ?>> functions;

    DefaultMarketDataFactory(ObservableDataProvider observableDataProvider, TimeSeriesProvider timeSeriesProvider, List<MarketDataFunction<?, ?>> functions) {
        this.observableDataProvider = observableDataProvider;
        this.timeSeriesProvider = timeSeriesProvider;
        HashMap builderMap = new HashMap();
        functions.stream().forEach(builder -> builderMap.put(builder.getMarketDataIdType(), builder));
        this.functions = ImmutableMap.copyOf(builderMap);
    }

    @Override
    public BuiltMarketData create(MarketDataRequirements requirements, MarketDataConfig marketDataConfig, MarketData suppliedData, ReferenceData refData) {
        ScenarioMarketData md = ScenarioMarketData.of((int)1, (MarketData)suppliedData);
        BuiltScenarioMarketData smd = this.createMultiScenario(requirements, marketDataConfig, md, refData, ScenarioDefinition.empty());
        return new BuiltMarketData(smd);
    }

    @Override
    public BuiltScenarioMarketData createMultiScenario(MarketDataRequirements requirements, MarketDataConfig marketDataConfig, MarketData suppliedData, ReferenceData refData, ScenarioDefinition scenarioDefinition) {
        ScenarioMarketData md = ScenarioMarketData.of((int)1, (MarketData)suppliedData);
        return this.createMultiScenario(requirements, marketDataConfig, md, refData, scenarioDefinition);
    }

    @Override
    public BuiltScenarioMarketData createMultiScenario(MarketDataRequirements requirements, MarketDataConfig marketDataConfig, ScenarioMarketData suppliedData, ReferenceData refData, ScenarioDefinition scenarioDefinition) {
        BuiltScenarioMarketDataBuilder dataBuilder = BuiltScenarioMarketData.builder((MarketDataBox<LocalDate>)suppliedData.getValuationDate());
        BuiltScenarioMarketData builtData = dataBuilder.build();
        MarketDataNode root = MarketDataNode.buildDependencyTree(requirements, suppliedData, marketDataConfig, this.functions);
        while (!root.isLeaf()) {
            BuiltScenarioMarketData marketData = builtData;
            Pair<MarketDataNode, MarketDataRequirements> pair = root.withLeavesRemoved();
            MarketDataRequirements leafRequirements = (MarketDataRequirements)pair.getSecond();
            leafRequirements.getTimeSeries().stream().filter(id -> marketData.getTimeSeries((ObservableId)id).isEmpty()).filter(id -> suppliedData.getTimeSeries(id).isEmpty()).forEach(id -> dataBuilder.addTimeSeriesResult((ObservableId)id, this.timeSeriesProvider.provideTimeSeries((ObservableId)id)));
            leafRequirements.getTimeSeries().stream().filter(id -> !suppliedData.getTimeSeries(id).isEmpty()).forEach(id -> dataBuilder.addTimeSeries((ObservableId)id, suppliedData.getTimeSeries(id)));
            Set observableIds = (Set)leafRequirements.getObservables().stream().filter(Guavate.not(marketData::containsValue)).filter(Guavate.not(arg_0 -> ((ScenarioMarketData)suppliedData).containsValue(arg_0))).collect(Guavate.toImmutableSet());
            if (!observableIds.isEmpty()) {
                Map<ObservableId, Result<Double>> observableResults = this.observableDataProvider.provideObservableData(observableIds);
                MapStream.of(observableResults).forEach((id, res) -> this.addObservableResult((ObservableId)id, (Result<Double>)res, refData, scenarioDefinition, dataBuilder));
            }
            leafRequirements.getObservables().stream().filter(arg_0 -> ((ScenarioMarketData)suppliedData).containsValue(arg_0)).forEach(id -> this.addValue((MarketDataId<?>)id, (MarketDataBox<?>)suppliedData.getValue((MarketDataId)id), refData, scenarioDefinition, dataBuilder));
            Set nonObservableIds = (Set)leafRequirements.getNonObservables().stream().filter(Guavate.not(marketData::containsValue)).filter(Guavate.not(arg_0 -> ((ScenarioMarketData)suppliedData).containsValue(arg_0))).collect(Guavate.toImmutableSet());
            Map<MarketDataId<?>, Result<MarketDataBox<?>>> nonObservableResults = this.buildNonObservableData(nonObservableIds, marketDataConfig, marketData, refData);
            MapStream.of(nonObservableResults).forEach((id, result) -> this.addResult((MarketDataId<?>)id, (Result<MarketDataBox<?>>)result, refData, scenarioDefinition, dataBuilder));
            leafRequirements.getNonObservables().stream().filter(arg_0 -> ((ScenarioMarketData)suppliedData).containsValue(arg_0)).forEach(id -> this.addValue((MarketDataId<?>)id, (MarketDataBox<?>)suppliedData.getValue(id), refData, scenarioDefinition, dataBuilder));
            builtData = dataBuilder.build();
            root = (MarketDataNode)pair.getFirst();
        }
        return builtData;
    }

    private Result<MarketDataBox<?>> buildNonObservableData(MarketDataId id, MarketDataConfig marketDataConfig, BuiltScenarioMarketData suppliedData, ReferenceData refData) {
        Class<?> idClass = id.getClass();
        MarketDataFunction<?, ?> marketDataFunction = this.functions.get(idClass);
        if (marketDataFunction == null) {
            throw new IllegalStateException("No market data function available for market data ID of type " + idClass.getName());
        }
        return Result.of(() -> marketDataFunction.build(id, marketDataConfig, suppliedData, refData));
    }

    private Map<MarketDataId<?>, Result<MarketDataBox<?>>> buildNonObservableData(Set<? extends MarketDataId<?>> ids, MarketDataConfig marketDataConfig, BuiltScenarioMarketData marketData, ReferenceData refData) {
        return (Map)ids.stream().collect(Guavate.toImmutableMap(id -> id, id -> this.buildNonObservableData((MarketDataId)id, marketDataConfig, marketData, refData)));
    }

    private void addResult(MarketDataId<?> id, Result<MarketDataBox<?>> valueResult, ReferenceData refData, ScenarioDefinition scenarioDefinition, BuiltScenarioMarketDataBuilder builder) {
        if (valueResult.isFailure()) {
            builder.addResult(id, valueResult);
        } else {
            this.addValue(id, (MarketDataBox)valueResult.getValue(), refData, scenarioDefinition, builder);
        }
    }

    private void addObservableResult(ObservableId id, Result<Double> valueResult, ReferenceData refData, ScenarioDefinition scenarioDefinition, BuiltScenarioMarketDataBuilder builder) {
        if (valueResult.isFailure()) {
            builder.addResult(id, (Result<MarketDataBox<?>>)Result.failure(valueResult));
        } else {
            this.addValue((MarketDataId<?>)id, (MarketDataBox<?>)MarketDataBox.ofSingleValue((Object)valueResult.getValue()), refData, scenarioDefinition, builder);
        }
    }

    private void addValue(MarketDataId<?> id, MarketDataBox<?> value, ReferenceData refData, ScenarioDefinition scenarioDefinition, BuiltScenarioMarketDataBuilder builder) {
        Optional<PerturbationMapping> optionalMapping = scenarioDefinition.getMappings().stream().filter(m -> m.matches(id, value, refData)).findFirst();
        if (optionalMapping.isPresent()) {
            PerturbationMapping mapping = optionalMapping.get();
            MarketDataBox<?> objectValue = value;
            Result result = Result.of(() -> mapping.applyPerturbation(objectValue, refData));
            builder.addResult(id, result);
        } else {
            builder.addBox(id, value);
        }
    }
}

