/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.calc.marketdata.MarketDataConfigBuilder;
import com.opengamma.strata.calc.marketdata.SingleTypeMarketDataConfig;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.TypedString;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class MarketDataConfig
implements ImmutableBean,
Serializable {
    private static final MarketDataConfig EMPTY = new MarketDataConfig((Map<Class<?>, SingleTypeMarketDataConfig>)ImmutableMap.of(), (Map<Class<?>, Object>)ImmutableMap.of());
    @PropertyDefinition(validate="notNull", get="private")
    private final ImmutableMap<Class<?>, SingleTypeMarketDataConfig> configs;
    @PropertyDefinition(validate="notNull", get="private")
    private final ImmutableMap<Class<?>, Object> defaultConfigs;
    private static final long serialVersionUID = 1L;

    public static MarketDataConfig empty() {
        return EMPTY;
    }

    public static MarketDataConfigBuilder builder() {
        return new MarketDataConfigBuilder();
    }

    public <T> T get(Class<T> type, String name) {
        SingleTypeMarketDataConfig typeConfigs = (SingleTypeMarketDataConfig)this.configs.get(type);
        if (typeConfigs != null) {
            Object config2 = typeConfigs.get(name);
            if (config2 == null) {
                throw new IllegalArgumentException(Messages.format((String)"No configuration found with type {} and name {}", (Object[])new Object[]{type.getName(), name}));
            }
            return type.cast(config2);
        }
        if (!type.isInterface()) {
            throw new IllegalArgumentException("No configuration found for type " + type.getName());
        }
        ImmutableList potentialTypes = (ImmutableList)MapStream.of(this.configs).filterKeys(type::isAssignableFrom).map((t, config) -> config).filter(config -> config.getConfigObjects().containsKey((Object)name)).collect(Guavate.toImmutableList());
        if (potentialTypes.isEmpty()) {
            throw new IllegalArgumentException("No configuration found for type " + type.getName() + " or subclasses");
        }
        if (potentialTypes.size() > 1) {
            throw new IllegalArgumentException("Multiple configuration found for type " + type.getName());
        }
        return type.cast(((SingleTypeMarketDataConfig)potentialTypes.get(0)).get(name));
    }

    public <T> T get(Class<T> type, TypedString<?> name) {
        return this.get(type, name.getName());
    }

    public <T> T get(Class<T> type) {
        Object config = this.defaultConfigs.get(type);
        if (config == null) {
            throw new IllegalArgumentException("No default configuration found with type " + type.getName());
        }
        return (T)config;
    }

    public <T> Optional<T> find(Class<T> type) {
        return Optional.ofNullable(this.defaultConfigs.get(type));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    MarketDataConfig(Map<Class<?>, SingleTypeMarketDataConfig> configs, Map<Class<?>, Object> defaultConfigs) {
        JodaBeanUtils.notNull(configs, (String)"configs");
        JodaBeanUtils.notNull(defaultConfigs, (String)"defaultConfigs");
        this.configs = ImmutableMap.copyOf(configs);
        this.defaultConfigs = ImmutableMap.copyOf(defaultConfigs);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    private ImmutableMap<Class<?>, SingleTypeMarketDataConfig> getConfigs() {
        return this.configs;
    }

    private ImmutableMap<Class<?>, Object> getDefaultConfigs() {
        return this.defaultConfigs;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            MarketDataConfig other = (MarketDataConfig)obj;
            return JodaBeanUtils.equal(this.configs, other.configs) && JodaBeanUtils.equal(this.defaultConfigs, other.defaultConfigs);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.configs);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.defaultConfigs);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("MarketDataConfig{");
        buf.append("configs").append('=').append(JodaBeanUtils.toString(this.configs)).append(',').append(' ');
        buf.append("defaultConfigs").append('=').append(JodaBeanUtils.toString(this.defaultConfigs));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<MarketDataConfig> {
        private Map<Class<?>, SingleTypeMarketDataConfig> configs = ImmutableMap.of();
        private Map<Class<?>, Object> defaultConfigs = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 951117169: {
                    return this.configs;
                }
                case -1339733008: {
                    return this.defaultConfigs;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 951117169: {
                    this.configs = (Map)newValue;
                    break;
                }
                case -1339733008: {
                    this.defaultConfigs = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public MarketDataConfig build() {
            return new MarketDataConfig(this.configs, this.defaultConfigs);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("MarketDataConfig.Builder{");
            buf.append("configs").append('=').append(JodaBeanUtils.toString(this.configs)).append(',').append(' ');
            buf.append("defaultConfigs").append('=').append(JodaBeanUtils.toString(this.defaultConfigs));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableMap<Class<?>, SingleTypeMarketDataConfig>> configs = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"configs", MarketDataConfig.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<Class<?>, Object>> defaultConfigs = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"defaultConfigs", MarketDataConfig.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"configs", "defaultConfigs"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 951117169: {
                    return this.configs;
                }
                case -1339733008: {
                    return this.defaultConfigs;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends MarketDataConfig> builder() {
            return new Builder();
        }

        public Class<? extends MarketDataConfig> beanType() {
            return MarketDataConfig.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableMap<Class<?>, SingleTypeMarketDataConfig>> configs() {
            return this.configs;
        }

        public MetaProperty<ImmutableMap<Class<?>, Object>> defaultConfigs() {
            return this.defaultConfigs;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 951117169: {
                    return ((MarketDataConfig)bean).getConfigs();
                }
                case -1339733008: {
                    return ((MarketDataConfig)bean).getDefaultConfigs();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

