/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.marketdata;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.calc.marketdata.MarketDataFilter;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.NamedMarketDataId;
import com.opengamma.strata.data.scenario.MarketDataBox;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light", constructorScope="package")
final class NameFilter<T>
implements MarketDataFilter<T, NamedMarketDataId<T>>,
ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final MarketDataName<T> name;
    private static final MetaBean META_BEAN = LightMetaBean.of(NameFilter.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"name"}, (Object[])new Object[0]);

    @Override
    public Class<?> getMarketDataIdType() {
        return NamedMarketDataId.class;
    }

    @Override
    public boolean matches(NamedMarketDataId<T> marketDataId, MarketDataBox<T> marketData, ReferenceData refData) {
        return marketDataId.getMarketDataName().equals(this.name);
    }

    public static MetaBean meta() {
        return META_BEAN;
    }

    NameFilter(MarketDataName<T> name) {
        JodaBeanUtils.notNull(name, (String)"name");
        this.name = name;
    }

    public TypedMetaBean<NameFilter<T>> metaBean() {
        return (TypedMetaBean)META_BEAN;
    }

    public MarketDataName<T> getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            NameFilter other = (NameFilter)obj;
            return JodaBeanUtils.equal(this.name, other.name);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.name);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("NameFilter{");
        buf.append("name").append('=').append(JodaBeanUtils.toString(this.name));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)META_BEAN);
    }
}

