/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.collect.Guavate;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class CalculationParameters
implements ImmutableBean,
Serializable {
    private static final CalculationParameters EMPTY = new CalculationParameters((Map<Class<? extends CalculationParameter>, CalculationParameter>)ImmutableMap.of());
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Class<? extends CalculationParameter>, CalculationParameter> parameters;
    private final ImmutableMap<Class<? extends CalculationParameter>, Class<? extends CalculationParameter>> aliases;
    private static final TypedMetaBean<CalculationParameters> META_BEAN = LightMetaBean.of(CalculationParameters.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"parameters"}, (Object[])new Object[]{ImmutableMap.of()});
    private static final long serialVersionUID = 1L;

    public static CalculationParameters empty() {
        return EMPTY;
    }

    public static CalculationParameters of(CalculationParameter ... parameters) {
        if (parameters.length == 0) {
            return EMPTY;
        }
        return new CalculationParameters((Map)Stream.of(parameters).collect(Guavate.toImmutableMap(p -> p.queryType())));
    }

    public static CalculationParameters of(List<? extends CalculationParameter> parameters) {
        if (parameters.isEmpty()) {
            return EMPTY;
        }
        return new CalculationParameters((Map)parameters.stream().collect(Guavate.toImmutableMap(p -> p.queryType())));
    }

    private CalculationParameters of(Map<Class<? extends CalculationParameter>, CalculationParameter> map) {
        if (map.isEmpty()) {
            return EMPTY;
        }
        return new CalculationParameters(map);
    }

    @ImmutableConstructor
    private CalculationParameters(Map<Class<? extends CalculationParameter>, CalculationParameter> parameters) {
        JodaBeanUtils.notNull(parameters, (String)"parameters");
        this.parameters = ImmutableMap.copyOf(parameters);
        HashMap<Class<CalculationParameter>, Class<? extends CalculationParameter>> aliases = new HashMap<Class<CalculationParameter>, Class<? extends CalculationParameter>>();
        for (Class<? extends CalculationParameter> type : parameters.keySet()) {
            Class<?>[] interfaces;
            for (Class<?> iface : interfaces = type.getInterfaces()) {
                if (iface == CalculationParameter.class || !CalculationParameter.class.isAssignableFrom(iface) || parameters.containsKey(iface)) continue;
                Class<CalculationParameter> aliasType = iface.asSubclass(CalculationParameter.class);
                aliases.putIfAbsent(aliasType, type);
            }
        }
        this.aliases = ImmutableMap.copyOf(aliases);
    }

    public CalculationParameters combinedWith(CalculationParameters other) {
        if (other.parameters.isEmpty()) {
            return this;
        }
        if (this.parameters.isEmpty()) {
            return other;
        }
        HashMap<Class<? extends CalculationParameter>, CalculationParameter> map = new HashMap<Class<? extends CalculationParameter>, CalculationParameter>((Map<Class<? extends CalculationParameter>, CalculationParameter>)other.getParameters());
        map.putAll((Map<Class<? extends CalculationParameter>, CalculationParameter>)this.parameters);
        return this.of(map);
    }

    public CalculationParameters with(CalculationParameter parameter) {
        HashMap<Class<? extends CalculationParameter>, CalculationParameter> map = new HashMap<Class<? extends CalculationParameter>, CalculationParameter>((Map<Class<? extends CalculationParameter>, CalculationParameter>)this.parameters);
        map.put(parameter.queryType(), parameter);
        return this.of(map);
    }

    public CalculationParameters without(Class<? extends CalculationParameter> type) {
        if (!this.parameters.containsKey(type)) {
            return this;
        }
        HashMap<Class<? extends CalculationParameter>, CalculationParameter> map = new HashMap<Class<? extends CalculationParameter>, CalculationParameter>((Map<Class<? extends CalculationParameter>, CalculationParameter>)this.parameters);
        map.remove(type);
        return this.of(map);
    }

    public CalculationParameters filter(CalculationTarget target, Measure measure) {
        ImmutableList filtered = (ImmutableList)this.parameters.values().stream().map(cp -> cp.filter(target, measure)).filter(opt -> opt.isPresent()).map(opt -> (CalculationParameter)opt.get()).collect(Guavate.toImmutableList());
        return CalculationParameters.of((List<? extends CalculationParameter>)filtered);
    }

    public <T extends CalculationParameter> Optional<T> findParameter(Class<T> type) {
        Class lookupType = (Class)this.aliases.getOrDefault(type, type);
        return Optional.ofNullable(type.cast(this.parameters.get((Object)lookupType)));
    }

    public <T extends CalculationParameter> T getParameter(Class<T> type) {
        Class lookupType = (Class)this.aliases.getOrDefault(type, type);
        Object calculationParameter = this.parameters.get((Object)lookupType);
        if (calculationParameter == null) {
            throw new IllegalArgumentException("No parameter found for query type " + type.getName());
        }
        return (T)((CalculationParameter)type.cast(calculationParameter));
    }

    public static TypedMetaBean<CalculationParameters> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<CalculationParameters> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<Class<? extends CalculationParameter>, CalculationParameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CalculationParameters other = (CalculationParameters)obj;
            return JodaBeanUtils.equal(this.parameters, other.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.parameters);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("CalculationParameters{");
        buf.append("parameters").append('=').append(JodaBeanUtils.toString(this.parameters));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

