/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ReferenceDataNotFoundException;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.calc.marketdata.MarketDataRequirementsBuilder;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.CalculationResult;
import com.opengamma.strata.calc.runner.CalculationResults;
import com.opengamma.strata.calc.runner.CalculationTaskCell;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.calc.runner.FxRateLookup;
import com.opengamma.strata.calc.runner.LookupScenarioFxRateProvider;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.FxRateId;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.data.scenario.ScenarioFxRateProvider;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class CalculationTask
implements ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final CalculationTarget target;
    @PropertyDefinition(validate="notNull")
    private final CalculationFunction<CalculationTarget> function;
    @PropertyDefinition(validate="notNull")
    private final CalculationParameters parameters;
    @PropertyDefinition(validate="notEmpty")
    private final List<CalculationTaskCell> cells;
    private static final TypedMetaBean<CalculationTask> META_BEAN = LightMetaBean.of(CalculationTask.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"target", "function", "parameters", "cells"}, (Object[])new Object[]{null, null, null, ImmutableList.of()});

    public static CalculationTask of(CalculationTarget target, CalculationFunction<? extends CalculationTarget> function, CalculationTaskCell ... cells) {
        return CalculationTask.of(target, function, CalculationParameters.empty(), (List<CalculationTaskCell>)ImmutableList.copyOf((Object[])cells));
    }

    public static CalculationTask of(CalculationTarget target, CalculationFunction<? extends CalculationTarget> function, CalculationParameters parameters, List<CalculationTaskCell> cells) {
        CalculationFunction<CalculationTarget> functionCast = function;
        return new CalculationTask(target, functionCast, parameters, cells);
    }

    public int getRowIndex() {
        return this.cells.get(0).getRowIndex();
    }

    public Set<Measure> getMeasures() {
        return (Set)this.cells.stream().map(c -> c.getMeasure()).collect(Guavate.toImmutableSet());
    }

    public MarketDataRequirements requirements(ReferenceData refData) {
        FunctionRequirements functionRequirements = this.function.requirements(this.target, this.getMeasures(), this.parameters, refData);
        ObservableSource obsSource = functionRequirements.getObservableSource();
        MarketDataRequirementsBuilder requirementsBuilder = MarketDataRequirements.builder();
        for (ObservableId id : functionRequirements.getTimeSeriesRequirements()) {
            requirementsBuilder.addTimeSeries(id.withObservableSource(obsSource));
        }
        for (ObservableId id : functionRequirements.getValueRequirements()) {
            if (id instanceof ObservableId) {
                requirementsBuilder.addValues(new MarketDataId[]{id.withObservableSource(obsSource)});
                continue;
            }
            requirementsBuilder.addValues(new MarketDataId[]{id});
        }
        for (CalculationTaskCell cell : this.cells) {
            if (!cell.getMeasure().isCurrencyConvertible() || cell.getReportingCurrency().isNone()) continue;
            Currency reportingCurrency = cell.reportingCurrency(this, refData);
            List fxRateIds = (List)functionRequirements.getOutputCurrencies().stream().filter(outputCurrency -> !outputCurrency.equals((Object)reportingCurrency)).map(outputCurrency -> CurrencyPair.of((Currency)outputCurrency, (Currency)reportingCurrency)).map(pair -> FxRateId.of((CurrencyPair)pair, (ObservableSource)obsSource)).collect(Guavate.toImmutableList());
            requirementsBuilder.addValues(fxRateIds);
        }
        return requirementsBuilder.build();
    }

    public Currency naturalCurrency(ReferenceData refData) {
        return this.function.naturalCurrency(this.target, refData);
    }

    public CalculationResults execute(ScenarioMarketData marketData, ReferenceData refData) {
        Map<Measure, Result<?>> results = this.calculate(marketData, refData);
        ScenarioFxRateProvider fxProvider = this.parameters.findParameter(FxRateLookup.class).map(lookup -> LookupScenarioFxRateProvider.of(marketData, lookup)).orElse(ScenarioFxRateProvider.of((ScenarioMarketData)marketData));
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (CalculationTaskCell cell : this.cells) {
            resultBuilder.add((Object)cell.createResult(this, this.target, results, fxProvider, refData));
        }
        return CalculationResults.of(this.target, (List<CalculationResult>)resultBuilder.build());
    }

    private Map<Measure, Result<?>> calculate(ScenarioMarketData marketData, ReferenceData refData) {
        try {
            Set<Measure> requestedMeasures = this.getMeasures();
            Set<Measure> supportedMeasures = this.function.supportedMeasures();
            Sets.SetView measures = Sets.intersection(requestedMeasures, supportedMeasures);
            Object map = ImmutableMap.of();
            if (!measures.isEmpty()) {
                map = this.function.calculate(this.target, (Set<Measure>)measures, this.parameters, marketData, refData);
            }
            if (!map.keySet().containsAll(requestedMeasures)) {
                return this.handleMissing(requestedMeasures, supportedMeasures, (Map<Measure, Result<?>>)map);
            }
            return map;
        }
        catch (RuntimeException ex) {
            return this.handleFailure(ex);
        }
    }

    private Map<Measure, Result<?>> handleMissing(Set<Measure> requestedMeasures, Set<Measure> supportedMeasures, Map<Measure, Result<?>> calculatedResults) {
        HashMap updated = new HashMap(calculatedResults);
        String fnName = this.function.getClass().getSimpleName();
        for (Measure requestedMeasure : requestedMeasures) {
            if (calculatedResults.containsKey(requestedMeasure)) continue;
            if (supportedMeasures.contains(requestedMeasure)) {
                String msg = this.function.identifier(this.target).map(v -> "for ID '" + v + "'").orElse("for target '" + this.target.toString() + "'");
                updated.put(requestedMeasure, Result.failure((FailureReason)FailureReason.CALCULATION_FAILED, (String)"Function '{}' did not return requested measure '{}' {}", (Object[])new Object[]{fnName, requestedMeasure, msg}));
                continue;
            }
            updated.put(requestedMeasure, Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Measure '{}' is not supported by function '{}'", (Object[])new Object[]{requestedMeasure, fnName}));
        }
        return updated;
    }

    private Map<Measure, Result<?>> handleFailure(RuntimeException ex) {
        String fnName = this.function.getClass().getSimpleName();
        String exMsg = ex.getMessage();
        Optional<String> id = this.function.identifier(this.target);
        String msg = id.map(v -> " for ID '" + v + "': " + exMsg).orElse(": " + exMsg + ": for target '" + this.target.toString() + "'");
        Result failure = ex instanceof MarketDataNotFoundException ? Result.failure((FailureReason)FailureReason.MISSING_DATA, (Exception)ex, (String)"Missing market data when invoking function '{}'{}", (Object[])new Object[]{fnName, msg}) : (ex instanceof ReferenceDataNotFoundException ? Result.failure((FailureReason)FailureReason.MISSING_DATA, (Exception)ex, (String)"Missing reference data when invoking function '{}'{}", (Object[])new Object[]{fnName, msg}) : (ex instanceof UnsupportedOperationException ? Result.failure((FailureReason)FailureReason.UNSUPPORTED, (Exception)ex, (String)"Unsupported operation when invoking function '{}'{}", (Object[])new Object[]{fnName, msg}) : Result.failure((FailureReason)FailureReason.CALCULATION_FAILED, (Exception)ex, (String)"Error when invoking function '{}'{}", (Object[])new Object[]{fnName, msg})));
        return (Map)this.getMeasures().stream().collect(Guavate.toImmutableMap(m -> m, m -> failure));
    }

    public String toString() {
        return "CalculationTask" + this.cells;
    }

    public static TypedMetaBean<CalculationTask> meta() {
        return META_BEAN;
    }

    private CalculationTask(CalculationTarget target, CalculationFunction<CalculationTarget> function, CalculationParameters parameters, List<CalculationTaskCell> cells) {
        JodaBeanUtils.notNull((Object)target, (String)"target");
        JodaBeanUtils.notNull(function, (String)"function");
        JodaBeanUtils.notNull((Object)parameters, (String)"parameters");
        JodaBeanUtils.notEmpty(cells, (String)"cells");
        this.target = target;
        this.function = function;
        this.parameters = parameters;
        this.cells = ImmutableList.copyOf(cells);
    }

    public TypedMetaBean<CalculationTask> metaBean() {
        return META_BEAN;
    }

    public CalculationTarget getTarget() {
        return this.target;
    }

    public CalculationFunction<CalculationTarget> getFunction() {
        return this.function;
    }

    public CalculationParameters getParameters() {
        return this.parameters;
    }

    public List<CalculationTaskCell> getCells() {
        return this.cells;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CalculationTask other = (CalculationTask)obj;
            return JodaBeanUtils.equal((Object)this.target, (Object)other.target) && JodaBeanUtils.equal(this.function, other.function) && JodaBeanUtils.equal((Object)this.parameters, (Object)other.parameters) && JodaBeanUtils.equal(this.cells, other.cells);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.target);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.function);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.parameters);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.cells);
        return hash;
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

