/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationFunctions;
import com.opengamma.strata.calc.runner.DerivedCalculationFunction;
import com.opengamma.strata.calc.runner.DerivedCalculationFunctionWrapper;
import com.opengamma.strata.calc.runner.MissingConfigCalculationFunction;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.MapStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultCalculationFunctions
implements CalculationFunctions,
ImmutableBean,
Serializable {
    static final DefaultCalculationFunctions EMPTY = new DefaultCalculationFunctions((Map<Class<?>, CalculationFunction<?>>)ImmutableMap.of());
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<Class<?>, CalculationFunction<?>> functions;
    private static final TypedMetaBean<DefaultCalculationFunctions> META_BEAN = LightMetaBean.of(DefaultCalculationFunctions.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"functions"}, (Object[])new Object[]{ImmutableMap.of()});
    private static final long serialVersionUID = 1L;

    static DefaultCalculationFunctions of(Map<Class<?>, ? extends CalculationFunction<?>> functions) {
        return new DefaultCalculationFunctions((Map<Class<?>, CalculationFunction<?>>)ImmutableMap.copyOf(functions));
    }

    @ImmutableValidator
    private void validate() {
        for (Map.Entry entry : this.functions.entrySet()) {
            ArgChecker.isTrue((boolean)((CalculationFunction)entry.getValue()).targetType().isAssignableFrom((Class)entry.getKey()), (String)"Invalid map, key and function mismatch: {} and {}", (Object[])new Object[]{entry.getKey(), ((CalculationFunction)entry.getValue()).targetType()});
        }
    }

    @Override
    public <T extends CalculationTarget> CalculationFunction<? super T> getFunction(T target) {
        CalculationFunction<CalculationTarget> function = (CalculationFunction<CalculationTarget>)this.functions.get(target.getClass());
        return function != null ? function : MissingConfigCalculationFunction.INSTANCE;
    }

    @Override
    public <T extends CalculationTarget> Optional<CalculationFunction<? super T>> findFunction(T target) {
        CalculationFunction function = (CalculationFunction)this.functions.get(target.getClass());
        return Optional.ofNullable(function);
    }

    @Override
    public CalculationFunctions composedWith(DerivedCalculationFunction<?, ?> ... derivedFunctions) {
        Map<Class, List<DerivedCalculationFunction>> functionsByTargetType = Arrays.stream(derivedFunctions).collect(Collectors.groupingBy(fn -> fn.targetType()));
        List<CalculationFunction> wrappedFunctions = MapStream.of(functionsByTargetType).map((targetType, fns) -> this.wrap((Class<?>)targetType, (List<DerivedCalculationFunction<?, ?>>)fns)).collect(Collectors.toList());
        HashMap allFunctions = new HashMap((Map<Class<?>, CalculationFunction<?>>)this.functions);
        wrappedFunctions.forEach(fn -> allFunctions.put(fn.targetType(), (CalculationFunction<?>)fn));
        return CalculationFunctions.of(allFunctions);
    }

    private <T extends CalculationTarget, R> CalculationFunction<?> wrap(Class<?> targetType, List<DerivedCalculationFunction<?, ?>> derivedFunctions) {
        CalculationFunction<CalculationTarget> function = (CalculationFunction<CalculationTarget>)this.functions.get(targetType);
        if (function == null) {
            function = MissingConfigCalculationFunction.INSTANCE;
        }
        CalculationFunction<CalculationTarget> wrappedFn = function;
        for (DerivedCalculationFunction<?, ?> derivedFn : derivedFunctions) {
            CalculationFunction<CalculationTarget> wrappedFnCast = wrappedFn;
            DerivedCalculationFunction<?, ?> derivedFnCast = derivedFn;
            wrappedFn = new DerivedCalculationFunctionWrapper(derivedFnCast, wrappedFnCast);
        }
        return wrappedFn;
    }

    public static TypedMetaBean<DefaultCalculationFunctions> meta() {
        return META_BEAN;
    }

    private DefaultCalculationFunctions(Map<Class<?>, CalculationFunction<?>> functions) {
        JodaBeanUtils.notNull(functions, (String)"functions");
        this.functions = ImmutableMap.copyOf(functions);
        this.validate();
    }

    public TypedMetaBean<DefaultCalculationFunctions> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<Class<?>, CalculationFunction<?>> getFunctions() {
        return this.functions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultCalculationFunctions other = (DefaultCalculationFunctions)obj;
            return JodaBeanUtils.equal(this.functions, other.functions);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.functions);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("DefaultCalculationFunctions{");
        buf.append("functions").append('=').append(JodaBeanUtils.toString(this.functions));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

