/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;

public final class FunctionUtils {
    private FunctionUtils() {
    }

    public static <T> Collector<T, List<T>, ScenarioArray<T>> toScenarioArray() {
        return Collector.of(ArrayList::new, (a, b) -> a.add(b), (l, r) -> {
            l.addAll(r);
            return l;
        }, list -> FunctionUtils.buildResult(list), new Collector.Characteristics[0]);
    }

    private static <T, R> ScenarioArray<T> buildResult(List<T> results) {
        return ScenarioArray.of(results);
    }

    public static Collector<MultiCurrencyAmount, List<MultiCurrencyAmount>, MultiCurrencyScenarioArray> toMultiCurrencyValuesArray() {
        return Collector.of(ArrayList::new, (a, b) -> a.add(b), (l, r) -> {
            l.addAll(r);
            return l;
        }, list -> MultiCurrencyScenarioArray.of((List)list), new Collector.Characteristics[0]);
    }

    public static Collector<CurrencyAmount, List<CurrencyAmount>, CurrencyScenarioArray> toCurrencyValuesArray() {
        return Collector.of(ArrayList::new, (a, b) -> a.add(b), (l, r) -> {
            l.addAll(r);
            return l;
        }, list -> CurrencyScenarioArray.of((List)list), new Collector.Characteristics[0]);
    }

    public static Collector<Double, List<Double>, DoubleScenarioArray> toValuesArray() {
        return Collector.of(ArrayList::new, (a, b) -> a.add(b), (l, r) -> {
            l.addAll(r);
            return l;
        }, list -> DoubleScenarioArray.of((List)list), new Collector.Characteristics[0]);
    }

    public static void duplicateResult(Measure existingKey, Measure newKey, Map<Measure, Result<?>> mutableMeasureMap) {
        Result<?> result = mutableMeasureMap.get(existingKey);
        if (result == null) {
            return;
        }
        mutableMeasureMap.put(newKey, result);
    }
}

