/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.calc.runner.FxRateLookup;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.ScenarioFxRateProvider;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.io.Serializable;

class LookupScenarioFxRateProvider
implements ScenarioFxRateProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ScenarioMarketData marketData;
    private final FxRateLookup lookup;

    static ScenarioFxRateProvider of(ScenarioMarketData marketData, FxRateLookup lookup) {
        return new LookupScenarioFxRateProvider(marketData, lookup);
    }

    private LookupScenarioFxRateProvider(ScenarioMarketData marketData, FxRateLookup lookup) {
        this.marketData = (ScenarioMarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
        this.lookup = (FxRateLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
    }

    public int getScenarioCount() {
        return this.marketData.getScenarioCount();
    }

    public FxRateProvider fxRateProvider(int scenarioIndex) {
        return this.lookup.fxRateProvider(this.marketData.scenario(scenarioIndex));
    }
}

