/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.calc.runner;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.CalculationTarget;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

final class MissingConfigCalculationFunction
implements CalculationFunction<CalculationTarget> {
    static final CalculationFunction<CalculationTarget> INSTANCE = new MissingConfigCalculationFunction();

    private MissingConfigCalculationFunction() {
    }

    @Override
    public Class<CalculationTarget> targetType() {
        return CalculationTarget.class;
    }

    @Override
    public Set<Measure> supportedMeasures() {
        return ImmutableSet.copyOf((Collection)Measure.extendedEnum().lookupAllNormalized().values());
    }

    @Override
    public Currency naturalCurrency(CalculationTarget trade, ReferenceData refData) {
        throw new IllegalStateException("Function has no currency-convertible measures");
    }

    @Override
    public FunctionRequirements requirements(CalculationTarget target, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        return FunctionRequirements.empty();
    }

    @Override
    public Map<Measure, Result<?>> calculate(CalculationTarget target, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData marketData, ReferenceData refData) {
        throw new IllegalStateException(Messages.format((String)"No function configured for measures {} on '{}'", (Object[])new Object[]{measures, target.getClass().getSimpleName()}));
    }
}

