/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CsvOutput {
    private static final String DIGITS = "([0-9]+)";
    private static final String EXPONENT = "[eE][+-]?([0-9]+)";
    private static final Pattern FP_REGEX = Pattern.compile("(([0-9]+)(\\.)?(([0-9]+)?)([eE][+-]?([0-9]+))?)|(\\.(([0-9]+))([eE][+-]?([0-9]+))?)");
    private static final String COMMA = ",";
    private static final String NEW_LINE = System.lineSeparator();
    private final Appendable underlying;
    private final String newLine;
    private final String separator;
    private final boolean safeExpressions;

    public static CsvOutput standard(Appendable underlying) {
        return new CsvOutput(underlying, NEW_LINE, COMMA, false);
    }

    public static CsvOutput standard(Appendable underlying, String newLine) {
        return new CsvOutput(underlying, newLine, COMMA, false);
    }

    public static CsvOutput standard(Appendable underlying, String newLine, String separator) {
        return new CsvOutput(underlying, newLine, separator, false);
    }

    public static CsvOutput safe(Appendable underlying) {
        return new CsvOutput(underlying, NEW_LINE, COMMA, true);
    }

    public static CsvOutput safe(Appendable underlying, String newLine) {
        return new CsvOutput(underlying, newLine, COMMA, true);
    }

    public static CsvOutput safe(Appendable underlying, String newLine, String separator) {
        return new CsvOutput(underlying, newLine, separator, true);
    }

    @Deprecated
    public CsvOutput(Appendable underlying) {
        this(underlying, NEW_LINE, COMMA);
    }

    @Deprecated
    public CsvOutput(Appendable underlying, String newLine) {
        this(underlying, newLine, COMMA);
    }

    @Deprecated
    public CsvOutput(Appendable underlying, String newLine, String separator) {
        this(underlying, newLine, separator, true);
    }

    private CsvOutput(Appendable underlying, String newLine, String separator, boolean safeExpressions) {
        this.underlying = ArgChecker.notNull(underlying, "underlying");
        this.newLine = newLine;
        this.separator = separator;
        this.safeExpressions = safeExpressions;
    }

    public void writeLines(Iterable<? extends List<String>> lines, boolean alwaysQuote) {
        ArgChecker.notNull(lines, "lines");
        for (List<String> list : lines) {
            this.writeLine(list, alwaysQuote);
        }
    }

    public void writeLine(List<String> line) {
        this.writeLine(line, false);
    }

    public void writeLine(List<String> line, boolean alwaysQuote) {
        ArgChecker.notNull(line, "line");
        Unchecked.wrap(() -> this.underlying.append(this.formatLine(line, alwaysQuote)).append(this.newLine));
    }

    private String formatLine(List<String> line, boolean alwaysQuote) {
        return line.stream().map(entry -> this.formatEntry((String)entry, alwaysQuote)).collect(Collectors.joining(this.separator));
    }

    private String formatEntry(String entry, boolean alwaysQuote) {
        if (alwaysQuote || this.isQuotingRequired(entry)) {
            return this.quotedEntry(entry);
        }
        return entry;
    }

    private boolean isQuotingRequired(String entry) {
        return entry.indexOf(34) >= 0 || entry.indexOf(44) >= 0 || entry.trim().length() != entry.length() || this.isExpressionPrefix(entry);
    }

    private boolean isExpressionPrefix(String entry) {
        if (entry.isEmpty()) {
            return false;
        }
        char first = entry.charAt(0);
        if (first == '=' || first == '@') {
            return true;
        }
        if (this.safeExpressions && (first == '+' || first == '-')) {
            return !FP_REGEX.matcher(entry.substring(1)).matches();
        }
        return false;
    }

    private String quotedEntry(String entry) {
        StringBuilder buf = new StringBuilder(entry.length() + 8);
        if (this.safeExpressions && this.isExpressionPrefix(entry)) {
            buf.append('=');
        }
        buf.append('\"');
        buf.append(entry.replace("\"", "\"\""));
        buf.append('\"');
        return buf.toString();
    }
}

