/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Decimal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.function.UnaryOperator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class FixedScaleDecimal
implements Serializable,
Comparable<FixedScaleDecimal> {
    private static final long serialVersionUID = 1L;
    @PropertyDefinition
    private final Decimal decimal;
    @PropertyDefinition
    private final int fixedScale;

    public static FixedScaleDecimal of(Decimal decimal, int fixedScale) {
        return new FixedScaleDecimal(decimal, fixedScale);
    }

    @FromString
    public static FixedScaleDecimal parse(String str) {
        Decimal decimal = Decimal.parse(str);
        int decimalPointPos = str.lastIndexOf(46);
        return new FixedScaleDecimal(decimal, decimalPointPos < 0 ? 0 : str.length() - decimalPointPos);
    }

    private FixedScaleDecimal(Decimal decimal, int fixedScale) {
        ArgChecker.notNull(decimal, "decimal");
        if (fixedScale < decimal.scale()) {
            throw new IllegalArgumentException("Scale must be equal or greater than the scale of the decimal: " + fixedScale);
        }
        if (fixedScale > 18) {
            throw new IllegalArgumentException("Scale must be 18 or less: " + fixedScale);
        }
        this.decimal = decimal;
        this.fixedScale = fixedScale;
    }

    public Decimal decimal() {
        return this.decimal;
    }

    public int fixedScale() {
        return this.fixedScale;
    }

    public FixedScaleDecimal map(UnaryOperator<Decimal> fn) {
        return FixedScaleDecimal.of((Decimal)fn.apply(this.decimal), this.fixedScale);
    }

    public BigDecimal toBigDecimal() {
        return this.decimal.toBigDecimal().setScale(this.fixedScale);
    }

    @Override
    public int compareTo(FixedScaleDecimal other) {
        return this.decimal.compareTo(other.decimal);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FixedScaleDecimal) {
            FixedScaleDecimal other = (FixedScaleDecimal)obj;
            return this.decimal.equals(other.decimal) && this.fixedScale == other.fixedScale;
        }
        return false;
    }

    public int hashCode() {
        return this.decimal.hashCode() ^ this.fixedScale;
    }

    @ToString
    public String toString() {
        return this.decimal.formatAtLeast(this.fixedScale);
    }
}

