/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.opengamma.strata.collect.ArgChecker;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class NumberFormatter {
    private final ThreadLocal<NumberFormat> underlying;

    private NumberFormatter(NumberFormat format) {
        ArgChecker.notNull(format, "format");
        format.setParseIntegerOnly(false);
        this.underlying = ThreadLocal.withInitial(() -> (NumberFormat)format.clone());
    }

    public static NumberFormatter of(boolean grouped, int decimalPlaces) {
        return NumberFormatter.of(grouped, decimalPlaces, decimalPlaces);
    }

    public static NumberFormatter of(boolean grouped, int minDecimalPlaces, int maxDecimalPlaces) {
        ArgChecker.inRangeInclusive(minDecimalPlaces, 0, 9, "minDecimalPlaces");
        ArgChecker.inRangeInclusive(maxDecimalPlaces, 0, 9, "maxDecimalPlaces");
        ArgChecker.isTrue(minDecimalPlaces <= maxDecimalPlaces, "Expected minDecimalPlaces <= maxDecimalPlaces");
        return NumberFormatter.create(grouped, minDecimalPlaces, maxDecimalPlaces);
    }

    private static NumberFormatter create(boolean grouped, int minDecimalPlaces, int maxDecimalPlaces) {
        NumberFormat format = NumberFormat.getNumberInstance(Locale.ENGLISH);
        format.setGroupingUsed(grouped);
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(minDecimalPlaces);
        format.setMaximumFractionDigits(maxDecimalPlaces);
        return new NumberFormatter(format);
    }

    public static NumberFormatter ofPercentage(boolean grouped, int minDecimalPlaces, int maxDecimalPlaces) {
        ArgChecker.inRangeInclusive(minDecimalPlaces, 0, 9, "minDecimalPlaces");
        ArgChecker.inRangeInclusive(maxDecimalPlaces, 0, 9, "maxDecimalPlaces");
        ArgChecker.isTrue(minDecimalPlaces <= maxDecimalPlaces, "Expected minDecimalPlaces <= maxDecimalPlaces");
        NumberFormat format = NumberFormat.getPercentInstance(Locale.ENGLISH);
        format.setGroupingUsed(grouped);
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(minDecimalPlaces);
        format.setMaximumFractionDigits(maxDecimalPlaces);
        return new NumberFormatter(format);
    }

    public static NumberFormatter ofPattern(String pattern, Locale locale) {
        ArgChecker.notNull(pattern, "pattern");
        ArgChecker.notNull(locale, "locale");
        return new NumberFormatter(new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(locale)));
    }

    public static NumberFormatter ofLocalizedNumber(Locale locale) {
        ArgChecker.notNull(locale, "locale");
        return new NumberFormatter(NumberFormat.getInstance(locale));
    }

    public String format(double number) {
        return this.underlying.get().format(number);
    }

    public String format(long number) {
        return this.underlying.get().format(number);
    }

    public double parse(String text) {
        try {
            return this.underlying.get().parse(text).doubleValue();
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String toString() {
        return this.underlying.toString();
    }
}

