/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.timeseries;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.function.ObjDoublePredicate;
import com.opengamma.strata.collect.timeseries.LocalDateDoublePoint;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeriesBuilder;
import com.opengamma.strata.collect.timeseries.SparseLocalDateDoubleTimeSeries;
import com.opengamma.strata.collect.tuple.Pair;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

public interface LocalDateDoubleTimeSeries {
    public static LocalDateDoubleTimeSeries empty() {
        return SparseLocalDateDoubleTimeSeries.EMPTY;
    }

    public static LocalDateDoubleTimeSeries of(LocalDate date, double value) {
        ArgChecker.notNull(date, "date");
        return LocalDateDoubleTimeSeries.builder().put(date, value).build();
    }

    public static LocalDateDoubleTimeSeriesBuilder builder() {
        return new LocalDateDoubleTimeSeriesBuilder();
    }

    public static Collector<LocalDateDoublePoint, LocalDateDoubleTimeSeriesBuilder, LocalDateDoubleTimeSeries> collector() {
        return Collector.of(LocalDateDoubleTimeSeriesBuilder::new, LocalDateDoubleTimeSeriesBuilder::put, LocalDateDoubleTimeSeriesBuilder::putAll, LocalDateDoubleTimeSeriesBuilder::build, new Collector.Characteristics[0]);
    }

    public int size();

    public boolean isEmpty();

    public boolean containsDate(LocalDate var1);

    public OptionalDouble get(LocalDate var1);

    default public LocalDate getEarliestDate() {
        return this.dates().findFirst().orElseThrow(() -> new NoSuchElementException("Unable to return earliest date, time-series is empty"));
    }

    default public double getEarliestValue() {
        return this.values().findFirst().orElseThrow(() -> new NoSuchElementException("Unable to return earliest value, time-series is empty"));
    }

    public LocalDate getLatestDate();

    public double getLatestValue();

    public LocalDateDoubleTimeSeries subSeries(LocalDate var1, LocalDate var2);

    public LocalDateDoubleTimeSeries headSeries(int var1);

    public LocalDateDoubleTimeSeries tailSeries(int var1);

    public Stream<LocalDateDoublePoint> stream();

    public Stream<LocalDate> dates();

    public DoubleStream values();

    public void forEach(ObjDoubleConsumer<LocalDate> var1);

    public LocalDateDoubleTimeSeries mapDates(Function<? super LocalDate, ? extends LocalDate> var1);

    public LocalDateDoubleTimeSeries mapValues(DoubleUnaryOperator var1);

    public LocalDateDoubleTimeSeries filter(ObjDoublePredicate<LocalDate> var1);

    default public LocalDateDoubleTimeSeries intersection(LocalDateDoubleTimeSeries other, DoubleBinaryOperator mapper) {
        ArgChecker.notNull(other, "other");
        ArgChecker.notNull(mapper, "mapper");
        return new LocalDateDoubleTimeSeriesBuilder().putAll(this.stream().filter((? super T pt) -> other.containsDate(pt.getDate())).map(pt -> LocalDateDoublePoint.of(pt.getDate(), mapper.applyAsDouble(pt.getValue(), other.get(pt.getDate()).getAsDouble())))).build();
    }

    default public LocalDateDoubleTimeSeries union(LocalDateDoubleTimeSeries other, DoubleBinaryOperator mapper) {
        ArgChecker.notNull(other, "other");
        ArgChecker.notNull(mapper, "mapper");
        LocalDateDoubleTimeSeriesBuilder builder = new LocalDateDoubleTimeSeriesBuilder(this.stream());
        other.stream().forEach((? super T pt) -> builder.merge((LocalDateDoublePoint)pt, mapper));
        return builder.build();
    }

    default public Pair<LocalDateDoubleTimeSeries, LocalDateDoubleTimeSeries> partition(ObjDoublePredicate<LocalDate> predicate) {
        Map<Boolean, LocalDateDoubleTimeSeries> partitioned = this.stream().collect(Collectors.partitioningBy(pt -> predicate.test(pt.getDate(), pt.getValue()), LocalDateDoubleTimeSeries.collector()));
        return Pair.of(partitioned.get(true), partitioned.get(false));
    }

    default public Pair<LocalDateDoubleTimeSeries, LocalDateDoubleTimeSeries> partitionByValue(DoublePredicate predicate) {
        return this.partition((obj, value) -> predicate.test(value));
    }

    public LocalDateDoubleTimeSeriesBuilder toBuilder();
}

