/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.tuple.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Messages {
    private static final Pattern REGEX_WORDS_AND_EMPTY = Pattern.compile("\\{(\\w*)\\}");
    private static final Splitter TEMPLATE_LOCATION_SPLITTER = Splitter.on((char)'|');
    private static final Splitter TEMPLATE_PART_SPLITTER = Splitter.on((char)':');

    private Messages() {
    }

    public static String format(String messageTemplate, Object arg) {
        if (messageTemplate == null) {
            return Messages.format("", arg);
        }
        int placeholderPos = messageTemplate.indexOf("{}", 0);
        String argStr = String.valueOf(arg);
        StringBuilder builder = new StringBuilder(messageTemplate.length() + argStr.length() + 3);
        if (placeholderPos >= 0) {
            builder.append(messageTemplate.substring(0, placeholderPos)).append(argStr).append(messageTemplate.substring(placeholderPos + 2));
        } else {
            builder.append(messageTemplate).append(" - [").append(argStr).append(']');
        }
        return builder.toString();
    }

    public static String format(String messageTemplate, Object ... args) {
        int argIndex;
        if (messageTemplate == null) {
            return Messages.format("", args);
        }
        if (args == null) {
            return Messages.format(messageTemplate, new Object[0]);
        }
        StringBuilder builder = new StringBuilder(messageTemplate.length() + args.length * 20);
        int curPos = 0;
        int nextPlaceholderPos = messageTemplate.indexOf("{}", curPos);
        for (argIndex = 0; nextPlaceholderPos >= 0 && argIndex < args.length; ++argIndex) {
            builder.append(messageTemplate.substring(curPos, nextPlaceholderPos)).append(args[argIndex]);
            curPos = nextPlaceholderPos + 2;
            nextPlaceholderPos = messageTemplate.indexOf("{}", curPos);
        }
        builder.append(messageTemplate.substring(curPos));
        if (argIndex < args.length) {
            builder.append(" - [");
            for (int i = argIndex; i < args.length; ++i) {
                if (i > argIndex) {
                    builder.append(", ");
                }
                builder.append(args[i]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static Pair<String, Map<String, String>> formatWithAttributes(String messageTemplate, Object ... args) {
        if (messageTemplate == null) {
            return Messages.formatWithAttributes("", args);
        }
        if (args == null) {
            return Messages.formatWithAttributes(messageTemplate, new Object[0]);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher matcher = REGEX_WORDS_AND_EMPTY.matcher(messageTemplate);
        int argIndex = 0;
        StringBuffer outputMessageBuffer = new StringBuffer(128);
        StringBuffer templateLocationBuffer = new StringBuffer(32);
        boolean hasNamed = false;
        int previousEnd = 0;
        while (matcher.find()) {
            if (argIndex >= args.length) continue;
            String attributeName = matcher.group(1);
            String replacement = String.valueOf(args[argIndex]);
            outputMessageBuffer.append(messageTemplate.substring(previousEnd, matcher.start()));
            outputMessageBuffer.append(replacement);
            if (!attributeName.isEmpty()) {
                hasNamed = true;
                String oldAttrValue = (String)attributes.get(attributeName);
                if (oldAttrValue != null && !oldAttrValue.equals(replacement)) {
                    attributeName = "arg" + (argIndex + 1);
                }
                attributes.put(attributeName, replacement);
                templateLocationBuffer.append(templateLocationBuffer.length() > 0 ? "|" : "").append(attributeName).append(':').append(outputMessageBuffer.length() - replacement.length()).append(':').append(replacement.length());
            }
            previousEnd = matcher.end();
            ++argIndex;
        }
        outputMessageBuffer.append(messageTemplate.substring(previousEnd));
        if (argIndex < args.length) {
            if (hasNamed) {
                templateLocationBuffer.append(templateLocationBuffer.length() > 0 ? "|" : "").append("+:").append(outputMessageBuffer.length());
            }
            outputMessageBuffer.append(" - [");
            for (int i = argIndex; i < args.length; ++i) {
                if (i > argIndex) {
                    outputMessageBuffer.append(", ");
                }
                outputMessageBuffer.append(args[i]);
            }
            outputMessageBuffer.append(']');
        }
        if (hasNamed) {
            attributes.put("templateLocation", templateLocationBuffer.toString());
        } else {
            attributes.clear();
        }
        return Pair.of(outputMessageBuffer.toString(), ImmutableMap.copyOf(attributes));
    }

    public static String recreateTemplate(String message, String templateLocation) {
        if (Strings.nullToEmpty((String)message).isEmpty() || Strings.nullToEmpty((String)templateLocation).isEmpty()) {
            return message;
        }
        try {
            StringBuffer buf = new StringBuffer();
            int lastPos = 0;
            for (String entry : TEMPLATE_LOCATION_SPLITTER.split((CharSequence)templateLocation)) {
                int pos;
                String attrName = Guavate.substringBeforeFirst(entry, ":");
                String remainder = Guavate.substringAfterFirst(entry, ":");
                if (attrName.equals("+")) {
                    pos = Integer.parseInt(remainder);
                    buf.append(message.substring(lastPos, pos));
                    return buf.toString();
                }
                pos = Integer.parseInt(Guavate.substringBeforeFirst(remainder, ":"));
                int len = Integer.parseInt(Guavate.substringAfterFirst(remainder, ":"));
                buf.append(message.substring(lastPos, pos)).append('{').append(attrName).append('}');
                lastPos = pos + len;
            }
            buf.append(message.substring(lastPos));
            return buf.toString();
        }
        catch (RuntimeException ex) {
            return message;
        }
    }

    public static String mergeTemplateLocations(String location1, String location2, int message1Length) {
        if (message1Length < 0) {
            return "";
        }
        if (Strings.nullToEmpty((String)location2).isEmpty()) {
            return Strings.nullToEmpty((String)location1);
        }
        try {
            String adjLocation1 = Strings.nullToEmpty((String)location1);
            adjLocation1 = Guavate.substringBeforeFirst(Strings.nullToEmpty((String)location1), "|+:");
            adjLocation1 = adjLocation1.startsWith("+:") ? "" : adjLocation1;
            StringBuilder buf = new StringBuilder(64);
            buf.append(adjLocation1);
            block6: for (String entry : TEMPLATE_LOCATION_SPLITTER.split((CharSequence)location2)) {
                List parts = TEMPLATE_PART_SPLITTER.splitToList((CharSequence)entry);
                switch (parts.size()) {
                    case 2: {
                        String attrName = (String)parts.get(0);
                        if (!attrName.equals("+")) {
                            return "";
                        }
                        int pos = Integer.parseInt((String)parts.get(1));
                        buf.append(buf.length() == 0 ? "" : "|").append(attrName).append(':').append(pos + message1Length);
                        continue block6;
                    }
                    case 3: {
                        String attrName = (String)parts.get(0);
                        int pos = Integer.parseInt((String)parts.get(1));
                        int len = Integer.parseInt((String)parts.get(2));
                        buf.append(buf.length() == 0 ? "" : "|").append(attrName).append(':').append(pos + message1Length).append(':').append(len);
                        continue block6;
                    }
                }
                return "";
            }
            return buf.toString();
        }
        catch (RuntimeException ex) {
            return "";
        }
    }
}

