/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.Resources;
import com.opengamma.strata.collect.io.BeanCharSource;
import com.opengamma.strata.collect.io.StringCharSource;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class CharSources {
    private CharSources() {
    }

    public static CharSource ofFileName(String fileName) {
        return Files.asCharSource((File)new File(fileName), (Charset)Charsets.UTF_8);
    }

    public static CharSource ofFileName(String fileName, Charset charset) {
        return Files.asCharSource((File)new File(fileName), (Charset)charset);
    }

    public static CharSource ofFile(File file) {
        return Files.asCharSource((File)file, (Charset)Charsets.UTF_8);
    }

    public static CharSource ofFile(File file, Charset charset) {
        return Files.asCharSource((File)file, (Charset)charset);
    }

    public static CharSource ofPath(Path path) {
        return MoreFiles.asCharSource((Path)path, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
    }

    public static CharSource ofPath(Path path, Charset charset) {
        return MoreFiles.asCharSource((Path)path, (Charset)charset, (OpenOption[])new OpenOption[0]);
    }

    public static CharSource ofUrl(URL url) {
        return Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8);
    }

    public static CharSource ofUrl(URL url, Charset charset) {
        return Resources.asCharSource((URL)url, (Charset)charset);
    }

    public static StringCharSource ofContent(String content) {
        return StringCharSource.of(content);
    }

    public static StringCharSource ofContent(byte[] content) {
        return StringCharSource.fromBytesUtf8(content);
    }

    public static StringCharSource ofContent(byte[] content, Charset charset) {
        return StringCharSource.fromBytes(content, charset);
    }

    public static String extractFileName(CharSource source) {
        if (source instanceof BeanCharSource) {
            return ((BeanCharSource)source).getFileName().orElse("Unknown.txt");
        }
        if (source == null) {
            return "Null.txt";
        }
        String str = source.toString();
        if (str.startsWith("Files.asByteSource(")) {
            int pos = str.indexOf(41, 19);
            return Paths.get(str.substring(19, pos), new String[0]).getFileName().toString();
        }
        if (str.startsWith("MoreFiles.asByteSource(")) {
            int pos = str.indexOf(44, 23);
            return Paths.get(str.substring(23, pos), new String[0]).getFileName().toString();
        }
        if (str.startsWith("Resources.asByteSource(")) {
            int pos = str.indexOf(41, 23);
            String path = str.substring(23, pos);
            int lastSlash = path.lastIndexOf(47);
            return path.substring(lastSlash + 1);
        }
        return "Unknown.txt";
    }
}

