/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.io.CsvRow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public final class CsvFile {
    private final ImmutableList<String> headers;
    private final ImmutableMap<String, Integer> searchHeaders;
    private final ImmutableList<CsvRow> rows;

    public static CsvFile of(CharSource source, boolean headerRow) {
        return CsvFile.of(source, headerRow, ',');
    }

    public static CsvFile of(CharSource source, boolean headerRow, char separator) {
        ArgChecker.notNull(source, "source");
        List lines = (List)Unchecked.wrap(() -> source.readLines());
        return CsvFile.create(lines, headerRow, separator);
    }

    public static CsvFile of(Reader reader, boolean headerRow) {
        return CsvFile.of(reader, headerRow, ',');
    }

    public static CsvFile of(Reader reader, boolean headerRow, char separator) {
        ArgChecker.notNull(reader, "source");
        List lines = Unchecked.wrap(() -> CharStreams.readLines((Readable)reader));
        return CsvFile.create(lines, headerRow, separator);
    }

    private static CsvFile create(List<String> lines, boolean headerRow, char separator) {
        if (headerRow) {
            for (int i = 0; i < lines.size(); ++i) {
                ImmutableList<String> headers = CsvFile.parseLine(lines.get(i), separator);
                if (headers.isEmpty()) continue;
                ImmutableMap<String, Integer> searchHeaders = CsvFile.buildSearchHeaders(headers);
                return CsvFile.parseAll(lines, i + 1, separator, headers, searchHeaders);
            }
            throw new IllegalArgumentException("Could not read header row from empty CSV file");
        }
        return CsvFile.parseAll(lines, 0, separator, (ImmutableList<String>)ImmutableList.of(), (ImmutableMap<String, Integer>)ImmutableMap.of());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char findSeparator(CharSource source) {
        String possibleSeparators = ",;\t:|";
        try (BufferedReader breader = source.openBufferedStream();){
            int bestCount = 0;
            char bestSeparator = ',';
            String line = breader.readLine();
            int contentLines = 0;
            while (line != null && contentLines <= 100) {
                if (line.length() != 0 && !line.startsWith("#")) {
                    if (line.startsWith(";") && bestCount == 0 && bestSeparator == ',') {
                        bestSeparator = ';';
                    } else {
                        line = CsvFile.simplifyLine(line);
                        int lineBestCount = 0;
                        char lineBestSeparator = ',';
                        for (char c : possibleSeparators.toCharArray()) {
                            int count;
                            char c2;
                            if (line.contains((char)c + "\"\"")) {
                                c2 = c;
                                return (char)c2;
                            }
                            if (line.length() > 1 && line.equals(Strings.repeat((String)Character.toString(c), (int)line.length()))) {
                                c2 = c;
                                return (char)c2;
                            }
                            if (line.length() == 1 && line.charAt(0) == c && bestCount == 0 && bestSeparator == ',') {
                                bestCount = 1;
                                bestSeparator = c;
                            }
                            if (line.length() <= 1 || (count = CsvFile.parseLine(line, c).size()) <= lineBestCount) continue;
                            lineBestCount = count;
                            lineBestSeparator = c;
                        }
                        if (lineBestCount > 0) {
                            ++contentLines;
                            if (bestCount > 0 && bestCount == lineBestCount && bestSeparator == lineBestSeparator) break;
                            bestCount = lineBestCount;
                            bestSeparator = lineBestSeparator;
                        }
                    }
                }
                line = breader.readLine();
            }
            char c = bestSeparator;
            return (char)c;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static String simplifyLine(String line) {
        int pos = 0;
        boolean quoteMode = false;
        StringBuilder buf = new StringBuilder(line.length());
        while (pos < line.length()) {
            char ch = line.charAt(pos++);
            if (quoteMode) {
                if (ch == '\"' && pos < line.length() - 1 && line.charAt(pos) == '\"') {
                    ++pos;
                    continue;
                }
                if (ch != '\"' && pos != line.length()) continue;
                buf.append('\"').append('\"');
                quoteMode = false;
                continue;
            }
            if (ch == '\"') {
                quoteMode = true;
                continue;
            }
            if (ch == ' ' || ch == '=') continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    public static CsvFile of(List<String> headers, List<? extends List<String>> rows) {
        int size;
        ArgChecker.notNull(headers, "headers");
        ArgChecker.notNull(rows, "rows");
        int n = size = headers.size() == 0 && rows.size() > 0 ? rows.get(0).size() : headers.size();
        if (rows.stream().filter(row -> row.size() != size).findAny().isPresent()) {
            throw new IllegalArgumentException("Invalid data rows, each row must have same columns as header row");
        }
        ImmutableList copiedHeaders = ImmutableList.copyOf(headers);
        ImmutableMap<String, Integer> searchHeaders = CsvFile.buildSearchHeaders((ImmutableList<String>)copiedHeaders);
        ImmutableList.Builder csvRows = ImmutableList.builder();
        int firstLine = copiedHeaders.isEmpty() ? 1 : 2;
        for (int i = 0; i < rows.size(); ++i) {
            csvRows.add((Object)new CsvRow((ImmutableList<String>)copiedHeaders, searchHeaders, i + firstLine, (ImmutableList<String>)ImmutableList.copyOf((Collection)rows.get(i))));
        }
        return new CsvFile((ImmutableList<String>)copiedHeaders, searchHeaders, (ImmutableList<CsvRow>)csvRows.build());
    }

    private static CsvFile parseAll(List<String> lines, int lineIndex, char separator, ImmutableList<String> headers, ImmutableMap<String, Integer> searchHeaders) {
        ImmutableList.Builder rows = ImmutableList.builder();
        for (int i = lineIndex; i < lines.size(); ++i) {
            ImmutableList<String> fields = CsvFile.parseLine(lines.get(i), separator);
            if (fields.isEmpty()) continue;
            rows.add((Object)new CsvRow(headers, searchHeaders, i + 1, fields));
        }
        return new CsvFile(headers, searchHeaders, (ImmutableList<CsvRow>)rows.build());
    }

    static ImmutableList<String> parseLine(String line, char separator) {
        if (line.length() == 0 || line.startsWith("#") || line.startsWith(";") && separator != ';') {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        String terminated = line + separator;
        int pos = 0;
        int startPos = 0;
        String value = "";
        boolean valueMode = false;
        boolean quoteMode = false;
        while (pos < terminated.length()) {
            char ch = terminated.charAt(pos++);
            if (quoteMode) {
                if (ch == '\"' && pos < terminated.length() - 1 && terminated.charAt(pos) == '\"') {
                    ++pos;
                    continue;
                }
                if (ch == '\"') {
                    value = terminated.substring(startPos, pos - 1).replace("\"\"", "\"");
                    startPos = pos;
                    quoteMode = false;
                    continue;
                }
                if (pos != terminated.length()) continue;
                builder.add((Object)terminated.substring(startPos, pos - 1).replace("\"\"", "\""));
                continue;
            }
            if (valueMode) {
                if (ch != separator) continue;
                builder.add((Object)(value + terminated.substring(startPos, pos - 1).trim()));
                valueMode = false;
                value = "";
                continue;
            }
            if (ch == separator) {
                builder.add((Object)"");
                continue;
            }
            if (ch == ' ' || ch == '=' && pos < terminated.length() - 1 && terminated.charAt(pos) == '\"') continue;
            if (ch == '\"') {
                startPos = pos;
                quoteMode = true;
                valueMode = true;
                continue;
            }
            startPos = pos - 1;
            valueMode = true;
        }
        ImmutableList fields = builder.build();
        if (!CsvFile.hasContent((ImmutableList<String>)fields)) {
            return ImmutableList.of();
        }
        return fields;
    }

    private static boolean hasContent(ImmutableList<String> fields) {
        for (String field : fields) {
            if (field.isEmpty()) continue;
            return true;
        }
        return false;
    }

    static ImmutableMap<String, Integer> buildSearchHeaders(ImmutableList<String> headers) {
        HashMap<String, Integer> searchHeaders = new HashMap<String, Integer>();
        for (int i = 0; i < headers.size(); ++i) {
            String searchHeader = ((String)headers.get(i)).toLowerCase(Locale.ENGLISH);
            searchHeaders.putIfAbsent(searchHeader, i);
        }
        return ImmutableMap.copyOf(searchHeaders);
    }

    private CsvFile(ImmutableList<String> headers, ImmutableMap<String, Integer> searchHeaders, ImmutableList<CsvRow> rows) {
        this.headers = headers;
        this.searchHeaders = searchHeaders;
        this.rows = rows;
    }

    public ImmutableList<String> headers() {
        return this.headers;
    }

    public ImmutableList<CsvRow> rows() {
        return this.rows;
    }

    public int rowCount() {
        return this.rows.size();
    }

    public CsvRow row(int index) {
        return (CsvRow)this.rows.get(index);
    }

    public boolean containsHeader(String header) {
        return this.searchHeaders.containsKey((Object)header.toLowerCase(Locale.ENGLISH));
    }

    public boolean containsHeaders(Collection<String> headers) {
        return headers.stream().allMatch(this::containsHeader);
    }

    public boolean containsHeader(Pattern headerPattern) {
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!headerPattern.matcher((CharSequence)this.headers.get(i)).matches()) continue;
            return true;
        }
        return false;
    }

    public CsvFile withHeaders(List<String> headers) {
        return CsvFile.of(headers, (List)this.rows.stream().map(CsvRow::fields).collect(Guavate.toImmutableList()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CsvFile) {
            CsvFile other = (CsvFile)obj;
            return this.headers.equals(other.headers) && this.rows.equals(other.rows);
        }
        return false;
    }

    public int hashCode() {
        return this.headers.hashCode() ^ this.rows.hashCode();
    }

    public String toString() {
        return "CsvFile" + this.headers.toString();
    }
}

