/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.MapStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public final class PropertySet {
    private static final PropertySet EMPTY = new PropertySet((ImmutableListMultimap<String, String>)ImmutableListMultimap.of());
    private final ImmutableListMultimap<String, String> keyValueMap;

    public static PropertySet empty() {
        return EMPTY;
    }

    public static PropertySet of(Map<String, String> keyValues) {
        ArgChecker.notNull(keyValues, "keyValues");
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            builder.put(entry);
        }
        return new PropertySet((ImmutableListMultimap<String, String>)builder.build());
    }

    public static PropertySet of(Multimap<String, String> keyValues) {
        ArgChecker.notNull(keyValues, "keyValues");
        return new PropertySet((ImmutableListMultimap<String, String>)ImmutableListMultimap.copyOf(keyValues));
    }

    private PropertySet(ImmutableListMultimap<String, String> keyValues) {
        this.keyValueMap = keyValues;
    }

    public MapStream<String, String> stream() {
        return MapStream.of(this.keyValueMap);
    }

    public ImmutableSet<String> keys() {
        return ImmutableSet.copyOf((Collection)this.keyValueMap.keySet());
    }

    public ImmutableListMultimap<String, String> asMultimap() {
        return this.keyValueMap;
    }

    public ImmutableMap<String, String> asMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : this.keys()) {
            builder.put((Object)key, (Object)this.value(key));
        }
        return builder.build();
    }

    public boolean isEmpty() {
        return this.keyValueMap.isEmpty();
    }

    public boolean contains(String key) {
        ArgChecker.notNull(key, "key");
        return this.keyValueMap.containsKey((Object)key);
    }

    public String value(String key) {
        ArgChecker.notNull(key, "key");
        ImmutableList values = this.keyValueMap.get((Object)key);
        if (values.size() == 0) {
            throw new IllegalArgumentException("Unknown key: " + key);
        }
        if (values.size() > 1) {
            return Joiner.on((char)',').join((Iterable)values);
        }
        return (String)values.get(0);
    }

    public Optional<String> findValue(String key) {
        ArgChecker.notNull(key, "key");
        ImmutableList values = this.keyValueMap.get((Object)key);
        if (values.size() == 0) {
            return Optional.empty();
        }
        if (values.size() > 1) {
            return Optional.of(Joiner.on((char)',').join((Iterable)values));
        }
        return Optional.of(values.get(0));
    }

    public ImmutableList<String> valueList(String key) {
        ArgChecker.notNull(key, "key");
        return (ImmutableList)MoreObjects.firstNonNull((Object)this.keyValueMap.get((Object)key), (Object)ImmutableList.of());
    }

    public PropertySet combinedWith(PropertySet other) {
        ArgChecker.notNull(other, "other");
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        ImmutableListMultimap.Builder map = ImmutableListMultimap.builder();
        map.putAll(this.keyValueMap);
        for (String key : other.keyValueMap.keySet()) {
            if (this.contains(key)) continue;
            map.putAll((Object)key, other.valueList(key));
        }
        return new PropertySet((ImmutableListMultimap<String, String>)map.build());
    }

    public PropertySet overrideWith(PropertySet other) {
        ArgChecker.notNull(other, "other");
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        ImmutableListMultimap.Builder map = ImmutableListMultimap.builder();
        for (String key : this.keyValueMap.keySet()) {
            if (other.contains(key)) {
                map.putAll((Object)key, other.valueList(key));
                continue;
            }
            map.putAll((Object)key, this.valueList(key));
        }
        for (String key : other.keyValueMap.keySet()) {
            if (this.contains(key)) continue;
            map.putAll((Object)key, other.valueList(key));
        }
        return new PropertySet((ImmutableListMultimap<String, String>)map.build());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertySet) {
            return this.keyValueMap.equals(((PropertySet)obj).keyValueMap);
        }
        return false;
    }

    public int hashCode() {
        return this.keyValueMap.hashCode();
    }

    public String toString() {
        return this.keyValueMap.toString();
    }
}

